/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.api;

import org.mule.connectivity.exception.GenerationException;
import org.mule.connectivity.exception.UnsupportedMediaTypeException;
import org.mule.connectivity.model.ConnectorCategory;
import org.mule.connectivity.model.api.RestConnectAPIModel;
import org.mule.connectivity.model.api.builder.ConnectorModelBuilder;
import org.mule.connectivity.model.operation.ConnectorOperation;
import org.mule.connectivity.util.ParserUtils;
import org.raml.v2.api.model.v10.methods.Method;

public class ConnectorModel
extends RestConnectAPIModel<ConnectorOperation> {
    private final String connectorClassName;
    private final ConnectorCategory category;

    public ConnectorModel(ConnectorModelBuilder builder) throws GenerationException {
        super(builder);
        this.category = builder.getCategory();
        this.connectorClassName = ParserUtils.removeSpacesAndHyphens(this.apiName) + "Connector";
    }

    @Override
    protected ConnectorOperation createOperation(Method method) throws UnsupportedMediaTypeException {
        return new ConnectorOperation(method);
    }

    @Override
    protected String getDefaultGroupId() {
        return "org.mule.modules";
    }

    @Override
    protected String getDefaultArtifactId() {
        return "mule-module-" + ParserUtils.removeSpaces(this.apiName).toLowerCase();
    }

    public String getConnectorName() {
        return ParserUtils.getXmlName(this.apiName);
    }

    public String getBasePackage() {
        return this.groupId + "." + ParserUtils.removeSpacesAndHyphens(this.apiName).toLowerCase();
    }

    public ConnectorCategory getCategory() {
        return this.category;
    }

    public String getClassName() {
        return this.connectorClassName;
    }
}

