/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.connectivity.exception.GenerationException;
import org.mule.connectivity.exception.InvalidRAMLSourceException;
import org.mule.connectivity.exception.UnsupportedMediaTypeException;
import org.mule.connectivity.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.model.api.builder.RestConnectAPIModelBuilder;
import org.mule.connectivity.model.operation.Operation;
import org.mule.connectivity.model.security.APISecurityScheme;
import org.mule.connectivity.model.security.SecuritySchemeFactory;
import org.mule.connectivity.util.OperationMappingUtils;
import org.mule.connectivity.util.ParserUtils;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.methods.Method;

public abstract class RestConnectAPIModel<T extends Operation> {
    public static final String DEFAULT_VERSION = "1.0.0-BETA";
    public static final String VERSION_URI_PARAM = "{version}";
    public static final String VERSION_URI_PARAM_REGEX = "\\{version\\}";
    protected static final Logger logger = LogManager.getLogger(RestConnectAPIModel.class);
    protected final Api api;
    protected final List<T> operations;
    protected final List<APISecurityScheme> securitySchemes;
    protected final String apiName;
    protected String groupId;
    protected String artifactId;
    protected String version;

    public RestConnectAPIModel(RestConnectAPIModelBuilder<?, ?> builder) throws GenerationException {
        this.api = RestConnectAPIModel.getAPIFromRamlFile(builder.getRaml());
        this.apiName = this.buildApiName(builder);
        this.groupId = this.buildGroupId(builder);
        this.artifactId = this.buildArtifactId(builder);
        this.version = this.buildVersion(builder);
        this.operations = this.buildOperationsModel();
        this.securitySchemes = this.buildSecurityModel(this.api);
    }

    private String buildApiName(RestConnectAPIModelBuilder<?, ?> builder) {
        if (!StringUtils.isBlank((String)builder.getApiName())) {
            return builder.getApiName();
        }
        return this.api.title().value();
    }

    private String buildVersion(RestConnectAPIModelBuilder<?, ?> builder) {
        if (!StringUtils.isBlank((String)builder.getVersion())) {
            return builder.getVersion();
        }
        String versionFromAnnotation = ParserUtils.getApiVersionFromAnnotation(this.api);
        if (!StringUtils.isBlank((String)versionFromAnnotation)) {
            return versionFromAnnotation;
        }
        return this.getDefaultVersion();
    }

    protected String getDefaultVersion() {
        return DEFAULT_VERSION;
    }

    private String buildGroupId(RestConnectAPIModelBuilder<?, ?> builder) {
        if (!StringUtils.isBlank((String)builder.getGroupId())) {
            return builder.getGroupId();
        }
        return this.getDefaultGroupId();
    }

    private String buildArtifactId(RestConnectAPIModelBuilder<?, ?> builder) {
        if (!StringUtils.isBlank((String)builder.getArtifactId())) {
            return builder.getArtifactId();
        }
        return this.getDefaultArtifactId();
    }

    private List<APISecurityScheme> buildSecurityModel(Api api) throws UnsupportedSecuritySchemeException {
        return SecuritySchemeFactory.getSchemes(api.securitySchemes());
    }

    public List<T> buildOperationsModel() throws GenerationException {
        List<Method> methods = OperationMappingUtils.getMethods(this.api);
        ArrayList<T> operations = new ArrayList<T>();
        for (Method method : methods) {
            if (OperationMappingUtils.isIgnored(method)) {
                logger.warn("Resource ignored: {} {}", (Object)method.method(), (Object)method.resource().resourcePath());
                continue;
            }
            operations.add(this.createOperation(method));
        }
        OperationMappingUtils.validateNoDuplicateOperations(operations);
        return operations;
    }

    public static Api getAPIFromRamlFile(File raml) {
        RamlModelResult ramlModelResult = new RamlModelBuilder().buildApi(raml);
        if (ramlModelResult.hasErrors()) {
            logger.error("Error detected in RAML: " + StringUtils.join((Collection)ramlModelResult.getValidationResults(), (String)", "));
            throw new InvalidRAMLSourceException("Invalid RAML.");
        }
        if (ramlModelResult.isVersion08()) {
            throw new InvalidRAMLSourceException("RAML 0.8 is not supported.");
        }
        if (ramlModelResult.getApiV10() == null) {
            throw new InvalidRAMLSourceException("Invalid RAML: the provided source isn't an API definition but a fragment.");
        }
        return ramlModelResult.getApiV10();
    }

    public List<APISecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public String getBaseUri() {
        if (this.api.baseUri() == null || !this.api.baseUriParameters().isEmpty()) {
            return "";
        }
        if (this.api.baseUri().value().contains(VERSION_URI_PARAM) && this.api.version() != null && !this.api.version().value().isEmpty()) {
            return this.api.baseUri().value().replaceAll(VERSION_URI_PARAM_REGEX, this.api.version().value());
        }
        if (this.api.baseUri().value().contains(VERSION_URI_PARAM)) {
            return "";
        }
        return this.api.baseUri().value();
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getApiDescription() {
        return this.api.description() == null ? "" : this.api.description().value();
    }

    public List<T> getOperations() {
        return this.operations;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    protected abstract T createOperation(Method var1) throws UnsupportedMediaTypeException;

    protected abstract String getDefaultGroupId();

    protected abstract String getDefaultArtifactId();
}

