/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.api.builder;

import java.io.File;
import org.mule.connectivity.exception.BuilderException;
import org.mule.connectivity.exception.GenerationException;
import org.mule.connectivity.model.api.RestConnectAPIModel;

public abstract class RestConnectAPIModelBuilder<T extends RestConnectAPIModelBuilder, U extends RestConnectAPIModel<?>> {
    private String apiName;
    private File raml;
    private String groupId;
    private String artifactId;
    private String version;

    public T withName(String apiName) {
        this.apiName = apiName;
        return (T)this;
    }

    public T fromRaml(File raml) {
        this.raml = raml;
        return (T)this;
    }

    public T fromRaml(String ramlFileName) {
        this.raml = new File(ramlFileName);
        return (T)this;
    }

    public T withGroupId(String groupId) {
        this.groupId = groupId;
        return (T)this;
    }

    public T withArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return (T)this;
    }

    public T withVersion(String version) {
        this.version = version;
        return (T)this;
    }

    public String getApiName() {
        return this.apiName;
    }

    public File getRaml() {
        return this.raml;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public U build() throws GenerationException {
        if (this.getRaml() == null) {
            throw new BuilderException("RAML file wasn't provided.");
        }
        return this.buildModel();
    }

    protected abstract U buildModel() throws GenerationException;
}

