/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.metadata;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.connectivity.model.metadata.model.JsonMetadataModel;
import org.mule.connectivity.model.metadata.model.MetadataModel;
import org.mule.connectivity.model.metadata.model.StringMetadataModel;
import org.mule.connectivity.model.metadata.model.XmlMetadataModel;
import org.mule.connectivity.predicate.HasBodyPredicate;
import org.mule.connectivity.predicate.IsSupportedTypePredicate;
import org.mule.connectivity.predicate.OkResponsePredicate;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.AnyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;

public class MetadataModelFactory {
    private static final Predicate<Response> okAndBodyPredicate = Predicates.and((Predicate)new OkResponsePredicate(), (Predicate)new HasBodyPredicate());
    private static final Logger logger = LogManager.getLogger(MetadataModelFactory.class);
    private final Method method;

    public MetadataModelFactory(Method method) {
        this.method = method;
    }

    public MetadataModel constructInputMetadata(String modelName) {
        return this.getModel(modelName, this.method.body());
    }

    public MetadataModel constructOutputMetadata(String modelName) {
        ArrayList<TypeDeclaration> mediaTypes = new ArrayList<TypeDeclaration>();
        for (Response response : Iterables.filter((Iterable)this.method.responses(), okAndBodyPredicate)) {
            mediaTypes.addAll(Collections2.filter((Collection)response.body(), (Predicate)new IsSupportedTypePredicate()));
        }
        return this.getModel(modelName, mediaTypes);
    }

    protected MetadataModel getModel(String className, List<TypeDeclaration> typeDeclarations) {
        Collection<TypeDeclaration> supportedTypeDeclarations = this.getTypeDeclarations(typeDeclarations);
        if (supportedTypeDeclarations == null) {
            return null;
        }
        TypeDeclaration typeDeclaration = supportedTypeDeclarations.iterator().next();
        if (typeDeclaration instanceof ObjectTypeDeclaration || typeDeclaration instanceof ArrayTypeDeclaration || typeDeclaration instanceof UnionTypeDeclaration) {
            return new JsonMetadataModel(className, typeDeclaration.toJsonSchema(), typeDeclaration.name());
        }
        if (typeDeclaration instanceof XMLTypeDeclaration) {
            XMLTypeDeclaration xmlMediaType = (XMLTypeDeclaration)typeDeclaration;
            return new XmlMetadataModel(className, xmlMediaType.schemaContent(), typeDeclaration.name());
        }
        if (typeDeclaration instanceof JSONTypeDeclaration) {
            JSONTypeDeclaration jsonMediaType = (JSONTypeDeclaration)typeDeclaration;
            return new JsonMetadataModel(className, jsonMediaType.schemaContent(), typeDeclaration.name());
        }
        if (typeDeclaration instanceof StringTypeDeclaration || typeDeclaration instanceof AnyTypeDeclaration) {
            return new StringMetadataModel(typeDeclaration.name());
        }
        logger.warn("Media type {} cannot be parsed for operation {} {}.", (Object)typeDeclaration.type(), (Object)this.method.resource().resourcePath(), (Object)this.method.method());
        return null;
    }

    private Collection<TypeDeclaration> getTypeDeclarations(List<TypeDeclaration> typeDeclarations) {
        if (typeDeclarations == null) {
            return null;
        }
        Collection supportedTypeDeclarations = Collections2.filter(typeDeclarations, (Predicate)new IsSupportedTypePredicate());
        if (supportedTypeDeclarations.isEmpty()) {
            return null;
        }
        if (supportedTypeDeclarations.size() > 1) {
            logger.warn("Operation {} {} contains more than one media type. Found: {} media types. Will use the first one.", (Object)this.method.resource().resourcePath(), (Object)this.method.method(), (Object)typeDeclarations.size());
        }
        return supportedTypeDeclarations;
    }
}

