/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.metadata.definition;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import java.io.File;
import java.io.IOException;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.RuleFactory;
import org.mule.connectivity.model.metadata.definition.CustomTypeDefinition;
import org.mule.connectivity.util.FileUtils;
import org.mule.connectivity.util.ParserUtils;

public class JsonTypeDefinition
extends CustomTypeDefinition {
    private static final String SCHEMA_EXTENSION = ".json";
    private final String name;
    private final String schema;
    private String generatedFQN;
    private static GenerationConfig config = new DefaultGenerationConfig(){

        public boolean isGenerateBuilders() {
            return true;
        }

        public String getTargetVersion() {
            return "1.7";
        }

        public boolean isIncludeHashcodeAndEquals() {
            return false;
        }
    };

    public JsonTypeDefinition(String name, String schema) {
        this.name = name;
        this.schema = schema;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public boolean definesElement() {
        return false;
    }

    @Override
    public String getElementName() {
        return null;
    }

    @Override
    public void generatePojo(String opName, File outputDir, String basePackage) throws IOException {
        SchemaMapper mapper = new SchemaMapper(new RuleFactory(config, (Annotator)new Jackson2Annotator(), new SchemaStore()), new SchemaGenerator());
        JCodeModel codeModel = new JCodeModel();
        JType generatedModel = mapper.generate(codeModel, opName, basePackage + ".pojo." + opName.toLowerCase(), FileUtils.createTempFile(this.schema).toURI().toURL());
        codeModel.build(outputDir);
        this.generatedFQN = generatedModel.fullName();
    }

    @Override
    protected String getFileExtension() {
        return SCHEMA_EXTENSION;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMule4Type() {
        return ParserUtils.getXmlName(this.name);
    }

    @Override
    public String getJavaType() {
        return this.generatedFQN;
    }
}

