/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.metadata.definition;

import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.mule.connectivity.model.metadata.definition.CustomTypeDefinition;
import org.mule.connectivity.util.FileUtils;
import org.mule.connectivity.util.ParserUtils;
import org.xml.sax.InputSource;

public class XmlTypeDefinition
extends CustomTypeDefinition {
    private static final String SCHEMA_EXTENSION = ".xsd";
    private final String name;
    private final String schema;
    private String generatedFQN;

    public XmlTypeDefinition(String name, String schema) {
        this.name = name;
        this.schema = schema;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public boolean definesElement() {
        return true;
    }

    @Override
    public String getElementName() {
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        XmlSchema schema = schemaCol.read((Reader)new StringReader(this.schema));
        return schema.getElements().keySet().isEmpty() ? null : schema.getElements().keySet().toArray()[0].toString();
    }

    @Override
    public void generatePojo(String opName, File outputDir, String basePackage) throws IOException {
        File tempFile = FileUtils.createTempFile(this.schema);
        SchemaCompiler sc = XJC.createSchemaCompiler();
        sc.forcePackageName(basePackage + ".pojo." + opName.toLowerCase());
        InputSource is = new InputSource(tempFile.getAbsolutePath());
        sc.parseSchema(is);
        S2JJAXBModel model = sc.bind();
        JCodeModel jCodeModel = model.generateCode(null, null);
        jCodeModel.build(outputDir);
        this.generatedFQN = ((Mapping)model.getMappings().iterator().next()).getType().getTypeClass().fullName();
    }

    @Override
    protected String getFileExtension() {
        return SCHEMA_EXTENSION;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMule4Type() {
        return ParserUtils.getXmlName(this.name);
    }

    @Override
    public String getJavaType() {
        return this.generatedFQN;
    }
}

