/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.operation;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import org.apache.commons.lang.WordUtils;
import org.mule.connectivity.exception.UnsupportedMediaTypeException;
import org.mule.connectivity.model.metadata.MetadataModelFactory;
import org.mule.connectivity.model.operation.Operation;
import org.mule.connectivity.model.parameter.PropertyParameter;
import org.mule.connectivity.util.ParserUtils;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.internal.utils.Inflector;

public class ConnectorOperation
extends Operation {
    public ConnectorOperation(Method method) throws UnsupportedMediaTypeException {
        super(method);
        MetadataModelFactory metadataModelFactory = new MetadataModelFactory(method);
        this.inputMetaData = metadataModelFactory.constructInputMetadata(WordUtils.capitalize((String)this.getMethodName()) + "Request");
        this.outputMetaData = metadataModelFactory.constructOutputMetadata(WordUtils.capitalize((String)this.getMethodName()) + "Response");
    }

    public String getMethodName() {
        return ParserUtils.getJavaName(this.canonicalName);
    }

    public String getTestClassName() {
        return WordUtils.capitalize((String)this.getMethodName()) + "TestCase";
    }

    public String getArguments() {
        ArrayList<String> stream = new ArrayList<String>();
        for (PropertyParameter parameter : this.parameters) {
            StringBuilder sb = new StringBuilder();
            sb.append(parameter.isRequired() ? "" : "@Optional");
            sb.append(" ");
            sb.append(parameter.getType().getJavaType());
            sb.append(" ");
            sb.append(Inflector.lowercamelcase((String)parameter.getJavaName()));
            stream.add(sb.toString());
        }
        if (this.inputMetaData != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("@RefOnly @Default(\"#[payload]\") ");
            sb.append(this.getInputMetadataClassName());
            sb.append(" entity");
            stream.add(sb.toString());
        }
        return Joiner.on((String)", ").join(stream);
    }

    public String getInputMetadataClassName() {
        return this.inputMetaData.getMetadataDefinition() != null ? this.inputMetaData.getMetadataDefinition().getJavaType() : "String";
    }

    public String getOutputMetadataClassName() {
        return this.outputMetaData.getMetadataDefinition() != null ? this.outputMetaData.getMetadataDefinition().getJavaType() : "String";
    }
}

