/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.parameter;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.model.metadata.definition.JsonTypeDefinition;
import org.mule.connectivity.model.metadata.definition.SimpleTypeDefinition;
import org.mule.connectivity.model.metadata.definition.TypeDefinition;
import org.mule.connectivity.util.ParserUtils;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.internal.utils.Inflector;

public class PropertyParameter {
    private final TypeDefinition type;
    private final String name;
    private final boolean required;
    private final String description;

    public PropertyParameter(TypeDeclaration input) {
        this.type = this.buildType(input);
        this.name = input.name();
        this.required = input.required();
        this.description = input.description() == null ? null : StringUtils.trimToNull((String)input.description().value());
    }

    private TypeDefinition buildType(TypeDeclaration input) {
        if (input instanceof ArrayTypeDeclaration || input instanceof UnionTypeDeclaration || input instanceof ObjectTypeDeclaration) {
            return new JsonTypeDefinition(input.name(), input.toJsonSchema());
        }
        return new SimpleTypeDefinition(input.type());
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return Inflector.lowercamelcase((String)this.name);
    }

    public String getJavaClassName() {
        return Inflector.uppercamelcase((String)this.name);
    }

    public String getXmlName() {
        return ParserUtils.getXmlName(this.name);
    }

    public TypeDefinition getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public static final class ParameterTransformFunction
    implements Function<TypeDeclaration, PropertyParameter> {
        @Nullable
        public PropertyParameter apply(@Nullable TypeDeclaration input) {
            return new PropertyParameter(input);
        }
    }
}

