/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.parameter;

import static org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType.PART;
import static org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils.getXmlName;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;

public class PartParameter extends Parameter {

  private boolean isFilePart;

  public PartParameter(String displayName, String externalName, TypeDefinition typeDefinition, String description,
                       boolean isFilePart) {
    super(buildInternalName(externalName), displayName, externalName, typeDefinition, description, false, null, false);
    this.isFilePart = isFilePart;
  }

  private static String buildInternalName(String externalName) {
    return getXmlName(externalName) + "-" + getXmlName(PART.getName());
  }

  public boolean isFilePart() {
    return isFilePart;
  }
}
