/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.model;

import java.util.List;

public class RequestDescriptor extends DescriptorElement {

  private List<ParameterDescriptor> header;
  private List<ParameterDescriptor> queryParameter;
  private List<ParameterDescriptor> uriParameter;
  private List<PartDescriptor> part;

  public RequestDescriptor(List<ParameterDescriptor> header,
                           List<ParameterDescriptor> queryParameter,
                           List<ParameterDescriptor> uriParameter,
                           List<PartDescriptor> part) {
    this.header = header;
    this.queryParameter = queryParameter;
    this.uriParameter = uriParameter;
    this.part = part;
  }

  public List<ParameterDescriptor> getHeader() {
    return header;
  }

  public List<ParameterDescriptor> getQueryParameter() {
    return queryParameter;
  }

  public List<ParameterDescriptor> getUriParameter() {
    return uriParameter;
  }

  public List<PartDescriptor> getPart() {
    return part;
  }
}
