/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;

import org.mule.connectivity.restconnect.internal.descriptor.model.ParameterDescriptor;

import java.util.List;

import static java.util.stream.Collectors.toList;
import static org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils.parseElementCoreDescription;
import static org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils.parseRestConnectIgnored;

public class DescriptorParameterParser {

  private static final String API_CONTRACT_PARAM_NAME = "http://a.ml/vocabularies.restc/apiContract#paramName";
  private static final String REST_CONNECT_FRIENDLY_NAME = "http://a.ml/vocabularies/restConnect#friendlyName";

  public List<ParameterDescriptor> parseParameters(List<DialectDomainElement> parameterElements) {
    return parameterElements.stream()
        .map(this::parseParameter)
        .collect(toList());
  }

  private ParameterDescriptor parseParameter(DialectDomainElement parameterElement) {
    return new ParameterDescriptor(getDisplayName(parameterElement),
                                   getExternalName(parameterElement),
                                   getDescription(parameterElement),
                                   getIgnored(parameterElement));
  }

  private boolean getIgnored(DialectDomainElement parameterElement) {
    return parseRestConnectIgnored(parameterElement);
  }

  private String getDisplayName(DialectDomainElement parameterElement) {
    List<Object> displayNames = parameterElement.getScalarByPropertyUri(REST_CONNECT_FRIENDLY_NAME);
    return displayNames.isEmpty() ? null : displayNames.get(0).toString();
  }

  private String getExternalName(DialectDomainElement parameterElement) {
    List<Object> externalNames = parameterElement.getScalarByPropertyUri(API_CONTRACT_PARAM_NAME);
    return externalNames.isEmpty() ? null : externalNames.get(0).toString();
  }

  private String getDescription(DialectDomainElement parameterElement) {
    return parseElementCoreDescription(parameterElement);
  }
}
