/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import static java.util.stream.Collectors.toList;
import static org.mule.connectivity.restconnect.internal.util.NamingUtil.isFriendlyName;
import static org.mule.connectivity.restconnect.internal.validation.ValidationRule.Level.ERROR;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PostValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

import java.util.List;

public class OperationNameMustBeFriendlyRule extends PostValidationRule {

  //R012
  public OperationNameMustBeFriendlyRule() {
    super("Operation display name seems not to be a friendly name",
          "The displayName should be a human readable name separated with spaces.",
          ERROR);
  }

  @Override
  public List<ValidationResult> postValidate(ConnectorDescriptor connectorDescriptor,
                                             APIModel apiModel,
                                             ConnectorModel connectorModel) {

    return connectorModel.getOperations().stream()
        .filter(x -> !isFriendlyName(x.getDisplayName()))
        .map(this::getValidationError)
        .collect(toList());
  }

  private ValidationResult getValidationError(ConnectorOperation connectorOperation) {
    String location =
        "Operation with PATH: " + connectorOperation.getPath() +
            " and METHOD: " + connectorOperation.getHttpMethod() +
            " display name is : " + connectorOperation.getDisplayName();

    return new ValidationResult(this, location);
  }
}
