/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.model;

import static org.apache.commons.lang3.StringUtils.isNotBlank;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;

import java.util.List;

import javax.ws.rs.core.MediaType;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APITypeModel {

  private Logger logger = LoggerFactory.getLogger(APITypeModel.class);

  protected Class<? extends TypeDefinition> typeDefinitionClass;
  protected MediaType mediaType;
  protected String example;
  protected List<String> enumValues;
  protected APITypeSchemaModel APITypeSchemaModel;
  protected APIPrimitiveTypeModel primitiveTypeModel;
  protected List<APIParameterModel> parts;
  protected APITypeModel innerType;
  protected List<APITypeModel> unionTypes;

  protected APITypeModel() {

  }

  protected APITypeModel(APIPrimitiveTypeModel primitiveTypeModel) {
    this.typeDefinitionClass = PrimitiveTypeDefinition.class;
    this.primitiveTypeModel = primitiveTypeModel;
  }

  protected MediaType getMediaTypeForStringOrNull(String mediaType) {
    try {
      return isNotBlank(mediaType) ? MediaType.valueOf(mediaType) : null;
    } catch (Exception e) {
      logger.error("Error getting media type", e);
      return null;
    }
  }

  public Class<? extends TypeDefinition> getTypeDefinitionClass() {
    return typeDefinitionClass;
  }

  public MediaType getMediaType() {
    return mediaType;
  }

  public String getExample() {
    return example;
  }

  public List<String> getEnumValues() {
    return enumValues;
  }

  public APITypeSchemaModel getAPITypeSchemaModel() {
    return APITypeSchemaModel;
  }

  public APIPrimitiveTypeModel getPrimitiveTypeModel() {
    return primitiveTypeModel;
  }

  public List<APIParameterModel> getParts() {
    return parts;
  }

  public APITypeModel getInnerType() {
    return innerType;
  }

  public List<APITypeModel> getUnionTypes() {
    return unionTypes;
  }
}
