/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.exception.UnsupportedPaginationParameterException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorCategory;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorPackage;
import org.mule.connectivity.restconnect.internal.connectormodel.Protocol;
import org.mule.connectivity.restconnect.internal.connectormodel.QueryParamArrayFormat;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorOperationBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.InPaginationParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.OutPaginationParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.Pagination;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.PaginationParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.ResponseValueExtraction;
import org.mule.connectivity.restconnect.internal.connectormodel.uri.BaseUri;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.InPaginationParameterDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.OutPaginationParameterDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.PaginationDeclarationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.PaginationParameterDescriptor;
import org.mule.connectivity.restconnect.internal.util.AMFWrapper;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.TypeSchemaPool;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class ConnectorModelBuilder {
    private static final List<Protocol> DEFAULT_PROTOCOLS = new ArrayList<Protocol>();
    private final ConnectorOperationBuilder connectorOperationBuilder = new ConnectorOperationBuilder(new TypeSchemaPool());

    public ConnectorModel buildConnectorModel(APIModel apiModel, ConnectorDescriptor connectorDescriptor) throws ModelGenerationException {
        AMFWrapper.initialize();
        List<Protocol> protocols = ConnectorModelBuilder.buildProtocols(apiModel);
        return new ConnectorModel(ConnectorModelBuilder.buildConnectorName(connectorDescriptor), connectorDescriptor.getConnectorDescription(), ConnectorModelBuilder.buildMavenGroup(connectorDescriptor), ConnectorModelBuilder.buildMavenArtifactId(connectorDescriptor), ConnectorModelBuilder.buildMavenVersion(connectorDescriptor), ConnectorModelBuilder.buildBasePackage(connectorDescriptor), ConnectorModelBuilder.buildConnectorCategory(connectorDescriptor), ConnectorModelBuilder.buildBaseUri(connectorDescriptor, apiModel, protocols), protocols, this.connectorOperationBuilder.buildOperations(apiModel, connectorDescriptor), ConnectorModelBuilder.buildPaginations(connectorDescriptor), ConnectorModelBuilder.buildExtensionXml(connectorDescriptor), ConnectorModelBuilder.buildSkipOutputTypeValidation(connectorDescriptor), this.buildQueryParamArrayFormat(connectorDescriptor));
    }

    protected QueryParamArrayFormat buildQueryParamArrayFormat(ConnectorDescriptor connectorDescriptor) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getQueryParamArrayFormat())) {
            return QueryParamArrayFormat.valueOf(connectorDescriptor.getQueryParamArrayFormat().toUpperCase());
        }
        return QueryParamArrayFormat.MULTIMAP;
    }

    private static String buildConnectorName(ConnectorDescriptor connectorDescriptor) {
        String connectorName = connectorDescriptor.getConnectorName().trim();
        if (connectorName.toLowerCase().endsWith("api")) {
            connectorName = connectorName.substring(0, connectorName.lastIndexOf("api"));
        }
        if (connectorName.toLowerCase().endsWith("connector")) {
            return connectorName;
        }
        return connectorName + " Connector";
    }

    private static Boolean buildSkipOutputTypeValidation(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getSkipOutputTypeValidation();
    }

    private static String buildExtensionXml(ConnectorDescriptor connectorDescriptor) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getExtensionXml())) {
            return connectorDescriptor.getExtensionXml();
        }
        return XmlUtils.getXmlName(connectorDescriptor.getConnectorName());
    }

    private static String buildBasePackage(ConnectorDescriptor connectorDescriptor) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getBaseJavaPackage())) {
            return connectorDescriptor.getBaseJavaPackage();
        }
        return ConnectorPackage.buildBasePackage(connectorDescriptor.getConnectorName());
    }

    private static List<Protocol> buildProtocols(APIModel apiModel) {
        return apiModel.getProtocols().isEmpty() ? DEFAULT_PROTOCOLS : apiModel.getProtocols();
    }

    private static String buildMavenGroup(ConnectorDescriptor connectorDescriptor) {
        return XmlUtils.removeMavenGroupUnwantedCharacters(connectorDescriptor.getConnectorGav().getGroupId());
    }

    private static String buildMavenArtifactId(ConnectorDescriptor connectorDescriptor) {
        return XmlUtils.removeMavenArtifactUnwantedCharacters(connectorDescriptor.getConnectorGav().getArtifactId());
    }

    private static String buildMavenVersion(ConnectorDescriptor connectorDescriptor) {
        return XmlUtils.removeMavenVersionUnwantedCharacters(connectorDescriptor.getConnectorGav().getVersion());
    }

    private static ConnectorCategory buildConnectorCategory(ConnectorDescriptor connectorDescriptor) {
        return ConnectorCategory.fromString(connectorDescriptor.getConnectorCategory());
    }

    private static BaseUri buildBaseUri(ConnectorDescriptor connectorDescriptor, APIModel apiModel, List<Protocol> supportedProtocols) {
        if (connectorDescriptor.getBaseUri() == null) {
            return apiModel.getBaseUri();
        }
        BaseUri generatedUri = new BaseUri(connectorDescriptor.getBaseUri().getValue(), BaseUri.Type.valueOfName(connectorDescriptor.getBaseUri().getType()), apiModel.getBaseUri().getApiVersion(), supportedProtocols);
        connectorDescriptor.getBaseUri().getMapping().forEach(x -> generatedUri.addMultipleBaseUri(x.getName(), x.getValue(), x.isDefault()));
        return generatedUri;
    }

    private static List<Pagination> buildPaginations(ConnectorDescriptor connectorDescriptor) throws UnsupportedPaginationParameterException {
        ArrayList<Pagination> paginations = new ArrayList<Pagination>(connectorDescriptor.getPaginations().size());
        for (PaginationDeclarationDescriptor paginationDescriptor : connectorDescriptor.getPaginations()) {
            paginations.add(new Pagination(paginationDescriptor.getName(), paginationDescriptor.getType(), ConnectorModelBuilder.getPagingDescriptorParameters(paginationDescriptor.getParameters())));
        }
        return paginations;
    }

    private static List<PaginationParameter> getPagingDescriptorParameters(List<PaginationParameterDescriptor> pagingParameters) throws UnsupportedPaginationParameterException {
        ArrayList<PaginationParameter> parameters = new ArrayList<PaginationParameter>(pagingParameters.size());
        for (PaginationParameterDescriptor parameterDescriptor : pagingParameters) {
            PaginationParameter paginationParameter;
            if (parameterDescriptor instanceof InPaginationParameterDescriptor) {
                ResponseValueExtraction valueExtraction = new ResponseValueExtraction(((InPaginationParameterDescriptor)parameterDescriptor).getValueExtraction().getLanguage(), ((InPaginationParameterDescriptor)parameterDescriptor).getValueExtraction().getContent());
                paginationParameter = new InPaginationParameter(parameterDescriptor.getName(), valueExtraction);
            } else if (parameterDescriptor instanceof OutPaginationParameterDescriptor) {
                paginationParameter = new OutPaginationParameter(parameterDescriptor.getName(), ((OutPaginationParameterDescriptor)parameterDescriptor).getValue());
            } else {
                throw new UnsupportedPaginationParameterException("Only In/Out pagination parameters are supported.");
            }
            parameters.add(paginationParameter);
        }
        return parameters;
    }

    static {
        DEFAULT_PROTOCOLS.add(Protocol.HTTP);
        DEFAULT_PROTOCOLS.add(Protocol.HTTPS);
    }
}

