/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import java.util.ArrayList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.descriptor.model.ParameterDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.SecuritySchemeDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParameterParser;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorTestConnectionParser;

public class DescriptorSecurityParser {
    private static final String AML_REST_CONNECT_SECURITY_SCHEME = "http://a.ml/vocabularies/restConnect#security";
    private static final String AML_REST_CONNECT_SECURITY_HEADERS = "http://a.ml/vocabularies/restConnect#securityHeaders";
    private static final String AML_REST_CONNECT_SECURITY_QUERY_PARAMETERS = "http://a.ml/vocabularies/restConnect#securityQueryParameters";
    private DescriptorParameterParser descriptorParameterParser = new DescriptorParameterParser();
    private DescriptorTestConnectionParser descriptorTestConnectionParser = new DescriptorTestConnectionParser();

    public List<SecuritySchemeDescriptor> parseSecurityScheme(DialectDomainElement element) {
        List securityDescriptors = element.getObjectPropertyUri(AML_REST_CONNECT_SECURITY_SCHEME);
        ArrayList<SecuritySchemeDescriptor> securitySchemeDescriptors = new ArrayList<SecuritySchemeDescriptor>(securityDescriptors.size());
        for (DialectDomainElement securityElement : securityDescriptors) {
            SecuritySchemeDescriptor securitySchemeDescriptor = new SecuritySchemeDescriptor(securityElement.localRefName(), this.parseHeaders(securityElement), this.parseQueryParameters(securityElement), DescriptorParserUtils.parseRestConnectIgnored(securityElement), this.descriptorTestConnectionParser.parseTestConnection(securityElement));
            securitySchemeDescriptors.add(securitySchemeDescriptor);
        }
        return securitySchemeDescriptors;
    }

    private List<ParameterDescriptor> parseHeaders(DialectDomainElement securityElement) {
        List apiSpecElements = securityElement.getObjectPropertyUri(AML_REST_CONNECT_SECURITY_HEADERS);
        return apiSpecElements.isEmpty() ? null : this.descriptorParameterParser.parseParameters(apiSpecElements);
    }

    private List<ParameterDescriptor> parseQueryParameters(DialectDomainElement securityElement) {
        List apiSpecElements = securityElement.getObjectPropertyUri(AML_REST_CONNECT_SECURITY_QUERY_PARAMETERS);
        return apiSpecElements.isEmpty() ? null : this.descriptorParameterParser.parseParameters(apiSpecElements);
    }
}

