/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkInputMetadataResolver;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;

public class SdkContent
extends JavaTemplateEntity {
    private final SdkInputMetadataResolver inputMetadataResolver;
    private final String contentParameterJavaName;
    private final boolean primary;

    public SdkContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) throws TemplatingException {
        this(outputDir, connectorModel, sdkConnector, operation, operation.getInputMetadata(), SdkContentKind.INPUT_METADATA, "", true);
    }

    public SdkContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition, SdkContentKind contentType, String partName, boolean primary) throws TemplatingException {
        super(outputDir, connectorModel);
        FileGenerationUtils.SchemaNameType schemaNameType = contentType.equals((Object)SdkContentKind.INPUT_METADATA) ? FileGenerationUtils.SchemaNameType.INPUT : FileGenerationUtils.SchemaNameType.PART;
        this.contentParameterJavaName = contentType.equals((Object)SdkContentKind.INPUT_METADATA) ? "content" : JavaUtils.getJavaLowerCamelNameFromXml(XmlUtils.getXmlName(partName)) + "Content";
        this.primary = primary;
        this.inputMetadataResolver = new SdkInputMetadataResolver(outputDir, connectorModel, sdkConnector, operation, typeDefinition, schemaNameType, partName);
    }

    private TypeName getTypeName() {
        return ParameterizedTypeName.get(TypedValue.class, (Type[])new Type[]{InputStream.class});
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.inputMetadataResolver.applyTemplates();
    }

    public ParameterSpec generateContentParameter() {
        ParameterSpec.Builder paramSpecBuilder = ParameterSpec.builder((TypeName)this.getTypeName(), (String)this.contentParameterJavaName, (Modifier[])new Modifier[0]).addAnnotation(this.generateContentAnnotation());
        if (this.inputMetadataResolver != null && this.inputMetadataResolver.getRequiresMetadataResolver()) {
            paramSpecBuilder.addAnnotation(this.generateMetadataResolverAnnotation());
        }
        return paramSpecBuilder.build();
    }

    private AnnotationSpec generateMetadataResolverAnnotation() {
        return AnnotationSpec.builder(TypeResolver.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)this.inputMetadataResolver.getPackage(), (String)this.inputMetadataResolver.getClassName(), (String[])new String[0])}).build();
    }

    private AnnotationSpec generateContentAnnotation() {
        return AnnotationSpec.builder(Content.class).addMember("primary", "$L", new Object[]{this.primary}).build();
    }

    public String getContentParameterJavaName() {
        return this.contentParameterJavaName;
    }

    public static enum SdkContentKind {
        INPUT_METADATA,
        PART;

    }
}

