/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.EndPointDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;

public class DescriptorPathMustExistInApiRule
extends PreValidationRule {
    public DescriptorPathMustExistInApiRule() {
        super("Descriptor PATHs must be present in the API spec", "Any path declared in the connector descriptor must be present in the API spec.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        List descriptorPaths = connectorDescriptor.getEndpoints().stream().map(EndPointDescriptor::getPath).collect(Collectors.toList());
        List apiPaths = apiModel.getOperationsModel().stream().map(APIOperationModel::getPath).distinct().collect(Collectors.toList());
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        for (String descriptorPath : descriptorPaths) {
            if (!apiPaths.stream().noneMatch(x -> x.equalsIgnoreCase(descriptorPath))) continue;
            validationResults.add(new ValidationResult(this, "Path: " + descriptorPath));
        }
        return validationResults;
    }
}

