/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.OperationDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PostValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;

public class PagedOperationsOperationMustDeclareResponseBodyRule
extends PostValidationRule {
    public PagedOperationsOperationMustDeclareResponseBodyRule() {
        super("Paged Operations must declare a response body", "All paginated operations must declare a an output type.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        List nullOutputAPIOperations = apiModel.getOperationsModel().stream().filter(this::hasNoTypeDefinition).collect(Collectors.toList());
        return nullOutputAPIOperations.stream().filter(nullOutputOperation -> this.operationIsPaginated(connectorDescriptor, (APIOperationModel)nullOutputOperation)).filter(nullOutputOperation -> !this.operationIsIgnored(connectorDescriptor, (APIOperationModel)nullOutputOperation)).filter(nullOutputOperation -> !this.typeDefinedInDescriptor(connectorDescriptor, (APIOperationModel)nullOutputOperation)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean operationIsIgnored(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).findFirst().orElse(null);
        return operationDescriptor != null && operationDescriptor.isIgnored();
    }

    private boolean hasNoTypeDefinition(APIOperationModel apiOperationModel) {
        if (apiOperationModel.getOutputMetadataModel().isEmpty()) {
            return true;
        }
        return apiOperationModel.getOutputMetadataModel().stream().anyMatch(PagedOperationsOperationMustDeclareResponseBodyRule::hasNoTypeDefinition);
    }

    private static boolean hasNoTypeDefinition(APITypeModel outputType) {
        MediaType outputMediaType = outputType.getMediaType();
        if (outputMediaType != null && outputMediaType.equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
            return false;
        }
        Class<? extends TypeDefinition> outputClass = outputType.getTypeDefinitionClass();
        TypeSchema typeSchema = outputType.getAPITypeSchemaModel().getTypeSchema();
        return typeSchema == null || outputClass == null || outputClass == EmptyTypeDefinition.class;
    }

    private boolean typeDefinedInDescriptor(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).findFirst().orElse(null);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputTypeSchema());
    }

    private boolean operationIsPaginated(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).findFirst().orElse(null);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getPagination());
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name();
        return new ValidationResult(this, location);
    }
}

