/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import static java.lang.Boolean.parseBoolean;

import java.util.List;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorEncodesParser {

  private static final String SKIP_OUTPUT_TYPE_VALIDATION = "http://a.ml/vocabularies/restConnect#skipOutputTypeValidation";
  private static final String EXTENSION_XML = "http://a.ml/vocabularies/restConnect#extensionXml";
  private static final String CONNECTOR_CATEGORY = "http://a.ml/vocabularies/restConnect#connectorCategory";
  private static final String CUSTOM_JAVA_PACKAGE = "http://a.ml/vocabularies/restConnect#baseJavaPackage";
  private static final String DEFAULT_INPUT_MEDIA_TYPE = "http://a.ml/vocabularies/restConnect#defaultInputMediaType";
  private static final String DEFAULT_OUTPUT_MEDIA_TYPE = "http://a.ml/vocabularies/restConnect#defaultOutputMediaType";

  public String parseJavaPackage(DialectDomainElement element) {
    List<Object> javaPackages = element.getScalarByPropertyUri(CUSTOM_JAVA_PACKAGE);
    return javaPackages.isEmpty() ? null : javaPackages.get(0).toString();
  }

  public String parseConnectorCategory(DialectDomainElement element) {
    List<Object> connectorCategories = element.getScalarByPropertyUri(CONNECTOR_CATEGORY);
    return connectorCategories.isEmpty() ? null : connectorCategories.get(0).toString();
  }

  public String parseExtensionXml(DialectDomainElement element) {
    List<Object> extensionXmls = element.getScalarByPropertyUri(EXTENSION_XML);
    return extensionXmls.isEmpty() ? null : extensionXmls.get(0).toString();
  }

  public String parseDefaultInputMediaType(DialectDomainElement element) {
    List<Object> defaultInputMediaTypes = element.getScalarByPropertyUri(DEFAULT_INPUT_MEDIA_TYPE);
    return defaultInputMediaTypes.isEmpty() ? null : defaultInputMediaTypes.get(0).toString();
  }

  public String parseDefaultOutputMediaType(DialectDomainElement element) {
    List<Object> defaultOutputMediaTypes = element.getScalarByPropertyUri(DEFAULT_OUTPUT_MEDIA_TYPE);
    return defaultOutputMediaTypes.isEmpty() ? null : defaultOutputMediaTypes.get(0).toString();
  }

  public Boolean parseSkipOutputTypeValidation(DialectDomainElement element) {
    List<Object> skipOutputTypeValidations = element.getScalarByPropertyUri(SKIP_OUTPUT_TYPE_VALIDATION);
    return skipOutputTypeValidations.isEmpty() ? null : parseBoolean(skipOutputTypeValidations.get(0).toString());
  }
}
