/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;

import java.nio.file.Path;

public class SdkOperationFactory {

  public static AbstractSdkOperation create(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                            ConnectorOperation operation) {
    if (operation.hasPagination()) {
      String pagingType = connectorModel.getPagination(operation.getPagination()).getType();
      if ("offset".equalsIgnoreCase(pagingType)) {
        return new SdkOffsetPaginationOperation(outputDir, connectorModel, sdkConnector, operation);
      } else if ("marker".equalsIgnoreCase(pagingType)) {
        return new SdkMarkerPaginationOperation(outputDir, connectorModel, sdkConnector, operation);
      } else if ("pageNumber".equalsIgnoreCase(pagingType)) {
        return new SdkPageNumberPaginationOperation(outputDir, connectorModel, sdkConnector, operation);
      }
    }

    return new SdkOperation(outputDir, connectorModel, sdkConnector, operation);
  }

}
