/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.JsonOutputTypeResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.XmlOutputTypeResolver;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;

import java.nio.file.Path;

public class SdkOutputTypeResolver extends SdkAbstractStaticTypeResolver {

  private String qName;

  public SdkOutputTypeResolver(Path outputDir,
                               ConnectorModel connectorModel,
                               ConnectorOperation operation,
                               TypeDefinition typeDefinition,
                               SdkTypeDefinition sdkTypeDefinition) {
    super(outputDir, connectorModel, operation, typeDefinition, sdkTypeDefinition);
  }

  protected Class<?> buildSuperclass(TypeDefinition typeDefinition) {
    if (requiresTypeResolver) {
      if (typeDefinition.getTypeSchema() instanceof XmlTypeSchema) {
        qName = ((XmlTypeSchema) typeDefinition.getTypeSchema()).getElementName();
        return XmlOutputTypeResolver.class;
      } else if (typeDefinition.getTypeSchema() instanceof JsonTypeSchema) {
        return JsonOutputTypeResolver.class;
      }

      throw new IllegalArgumentException("TypeSchema not supported as OutputTypeResolver");
    }

    return null;
  }

  public AnnotationSpec getOutputTypeResolverAnnotation() {
    if (requiresTypeResolver) {
      return AnnotationSpec
          .builder(OutputResolver.class)
          .addMember("output", "$T.class", ClassName.get(getPackage(), getClassName()))
          .build();
    }
    return null;
  }

  @Override
  protected String getClassNameSuffix() {
    return "OutputTypeResolver";
  }

  @Override
  protected boolean requiresQNameMethod() {
    return superclass.equals(XmlOutputTypeResolver.class);
  }

  @Override
  protected String getQName() {
    return qName;
  }


}
