/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.PagingJsonTypeResolver;

import java.nio.file.Path;

public class SdkPagingTypeResolver extends SdkOutputTypeResolver {

  public SdkPagingTypeResolver(Path outputDir,
                               ConnectorModel connectorModel,
                               ConnectorOperation operation,
                               TypeDefinition typeDefinition,
                               SdkTypeDefinition sdkTypeDefinition) {
    super(outputDir, connectorModel, operation, typeDefinition, sdkTypeDefinition);
  }

  @Override
  protected Class<?> buildSuperclass(TypeDefinition typeDefinition) {
    if (typeDefinition.getTypeSchema() instanceof XmlTypeSchema) {
      throw new IllegalArgumentException("Pagination for Xml not implemented yet.");
    } else if (typeDefinition.getTypeSchema() instanceof JsonTypeSchema) {
      return PagingJsonTypeResolver.class;
    }

    throw new IllegalArgumentException("TypeSchema not supported as PagingTypeResolver");
  }

  @Override
  protected boolean requiresCategoryNameMethod() {
    return false;
  }

  @Override
  protected String getClassNameSuffix() {
    return "PagingTypeResolver";
  }
}
