/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation;

import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

import java.util.List;

public abstract class ValidationRule {

  public enum Level {
    INFO, WARN, ERROR
  }

  protected final String description;
  protected final String summary;
  protected final Level level;

  protected ValidationRule(String description, String summary, Level level) {
    this.description = description;
    this.summary = summary;
    this.level = level;
  }

  public Level getLevel() {
    return level;
  }

  public String getDescription() {
    return description;
  }

  public String getSummary() {
    return summary;
  }

  public abstract List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel);

  public abstract List<ValidationResult> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel,
                                                      ConnectorModel connectorModel);

}
