/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import amf.client.model.domain.FileShape;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.Shape;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.webapi.model.APIPrimitiveTypeModel;

public class AMFPrimitiveTypeModel extends APIPrimitiveTypeModel {

  public AMFPrimitiveTypeModel(Shape shape) {
    this.primitiveType = getPrimitiveType(shape);
  }

  public AMFPrimitiveTypeModel(PrimitiveTypeDefinition.PrimitiveType primitiveTypeDefinition) {
    this.primitiveType = primitiveTypeDefinition;
  }

  protected enum ScalarShapeDataType {
    BOOLEAN("http://www.w3.org/2001/XMLSchema#boolean"), DATETIME("http://www.w3.org/2001/XMLSchema#dateTime"), DATETIME_ONLY(
        "http://a.ml/vocabularies/shapes#dateTimeOnly"), DATE("http://www.w3.org/2001/XMLSchema#date"), TIME(
            "http://www.w3.org/2001/XMLSchema#time"), FLOAT("http://www.w3.org/2001/XMLSchema#float"), DOUBLE(
                "http://www.w3.org/2001/XMLSchema#double"), NUMBER("http://a.ml/vocabularies/shapes#number"), INTEGER(
                    "http://www.w3.org/2001/XMLSchema#integer"), LONG(
                        "http://www.w3.org/2001/XMLSchema#long"), STRING("http://www.w3.org/2001/XMLSchema#string");

    private final String schema;

    ScalarShapeDataType(String schema) {
      this.schema = schema;
    }

    public boolean equalsIgnoreCase(String value) {
      return this.schema.equalsIgnoreCase(value);
    }
  }

  private PrimitiveTypeDefinition.PrimitiveType getPrimitiveType(Shape shape) {

    if (shape instanceof ScalarShape) {
      String dataType = ((ScalarShape) shape).dataType().value();

      if (ScalarShapeDataType.BOOLEAN.equalsIgnoreCase(dataType)) {
        return PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
      } else if (ScalarShapeDataType.DATETIME.equalsIgnoreCase(dataType)) {
        return PrimitiveTypeDefinition.PrimitiveType.DATE_TIME;
      } else if (ScalarShapeDataType.DATETIME_ONLY.equalsIgnoreCase(dataType)) {
        return PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY;
      } else if (ScalarShapeDataType.DATE.equalsIgnoreCase(dataType)) {
        return PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY;
      } else if (ScalarShapeDataType.TIME.equalsIgnoreCase(dataType)) {
        return PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY;
      } else if (ScalarShapeDataType.NUMBER.equalsIgnoreCase(dataType)) {
        return PrimitiveTypeDefinition.PrimitiveType.NUMBER;
      } else if (ScalarShapeDataType.FLOAT.equalsIgnoreCase(dataType)) {
        return PrimitiveTypeDefinition.PrimitiveType.NUMBER;
      } else if (ScalarShapeDataType.DOUBLE.equalsIgnoreCase(dataType)) {
        return PrimitiveTypeDefinition.PrimitiveType.NUMBER;
      } else if (ScalarShapeDataType.INTEGER.equalsIgnoreCase(dataType)) {
        return PrimitiveTypeDefinition.PrimitiveType.INTEGER;
      } else if (ScalarShapeDataType.LONG.equalsIgnoreCase(dataType)) {
        return PrimitiveTypeDefinition.PrimitiveType.INTEGER;
      } else if (ScalarShapeDataType.STRING.equalsIgnoreCase(dataType)) {
        return PrimitiveTypeDefinition.PrimitiveType.STRING;
      }
    }

    else if (shape instanceof FileShape) {
      return PrimitiveTypeDefinition.PrimitiveType.FILE;
    }

    //Reaching this line would mean that a new type is supported in AMF but we have not implemented it in Rest Connect yet
    throw new IllegalArgumentException("Type declaration is not a primitive type.");
  }

}
