/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf.security;

import amf.client.model.StrField;
import amf.client.model.domain.OAuth2Settings;
import org.mule.connectivity.restconnect.internal.webapi.parser.security.OAS2Oauth2Flows;
import org.mule.connectivity.restconnect.internal.webapi.parser.security.RAMLOauth2Flows;

public class AMFOauth2FlowsNaming {

  private AMFOauth2FlowsNaming() {}

  public static boolean isAuthorizationCode(OAuth2Settings oAuth2Settings) {
    if (oAuth2Settings.authorizationGrants() != null && !oAuth2Settings.authorizationGrants().isEmpty()) {
      for (StrField grant : oAuth2Settings.authorizationGrants()) {
        if (RAMLOauth2Flows.AUTHORIZATION_CODE.equalsIgnoreCase(grant.value())) {
          return true;
        }
      }
    }

    if (oAuth2Settings.flow().nonEmpty()) {
      return OAS2Oauth2Flows.ACCESS_CODE.equalsIgnoreCase(oAuth2Settings.flow().value());
    }

    return false;
  }

  public static boolean isClientCredentials(OAuth2Settings oAuth2Settings) {
    if (oAuth2Settings.authorizationGrants() != null && !oAuth2Settings.authorizationGrants().isEmpty()) {
      for (StrField grant : oAuth2Settings.authorizationGrants()) {
        if (RAMLOauth2Flows.CLIENT_CREDENTIALS.equalsIgnoreCase(grant.value())) {
          return true;
        }
      }
    }

    if (oAuth2Settings.flow().nonEmpty()) {
      return OAS2Oauth2Flows.APPLICATION.equalsIgnoreCase(oAuth2Settings.flow().value());
    }

    return false;
  }
}
