/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;

import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static org.apache.commons.lang3.StringUtils.trimToNull;

public class RPParameterModel extends APIParameterModel {

  private final TypeDeclaration typeDeclaration;

  public RPParameterModel(TypeDeclaration typeDeclaration, ParameterType parameterType, boolean isPassword) {
    this.typeDeclaration = typeDeclaration;

    this.externalName = typeDeclaration.name();
    this.displayName = buildDisplayName();
    this.parameterType = parameterType;
    this.defaultValue = buildDefaultValue();
    this.description = buildDescription();
    this.isPassword = isPassword;
    this.isRequired = typeDeclaration.required();
    this.typeModel = new RPTypeModel(typeDeclaration, null);
  }

  private String buildDisplayName() {
    return typeDeclaration.displayName() != null ? typeDeclaration.displayName().value() : typeDeclaration.name();
  }

  private String buildDefaultValue() {
    String defaultValue = typeDeclaration.defaultValue();

    return isNotBlank(defaultValue) ? defaultValue : null;
  }

  private String buildDescription() {
    return typeDeclaration.description() == null ? null : trimToNull(typeDeclaration.description().value());
  }

}
