/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.security;

import org.mule.connectivity.restconnect.internal.webapi.parser.security.RAMLOauth2Flows;

public class RPOauth2FlowsNaming {

  private RPOauth2FlowsNaming() {}

  public static boolean isAuthorizationCode(String name) {
    return RAMLOauth2Flows.AUTHORIZATION_CODE.equalsIgnoreCase(name);
  }

  public static boolean isClientCredentials(String name) {
    return RAMLOauth2Flows.CLIENT_CREDENTIALS.equalsIgnoreCase(name);
  }
}
