/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorCategory;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.Protocol;
import org.mule.connectivity.restconnect.internal.connectormodel.pagination.Pagination;
import org.mule.connectivity.restconnect.internal.connectormodel.uri.BaseUri;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class ConnectorModel {
    private String connectorName;
    private String connectorXmlName;
    private List<Protocol> protocols;
    private Map<String, Pagination> paginations = new HashMap<String, Pagination>();
    private String description;
    private BaseUri baseUri;
    private ConnectorCategory category;
    private List<ConnectorOperation> operations;
    private String mvnGroupId;
    private String mvnArtifactId;
    private String mvnVersion;
    private String basePackage;
    private String extensionXml;
    private Boolean skipOutputTypeValidation;

    public ConnectorModel(String connectorName, String description, String mvnGroupId, String mvnArtifactId, String mvnVersion, String basePackage, ConnectorCategory category, BaseUri baseUri, List<Protocol> protocols, List<ConnectorOperation> operations, List<Pagination> paginations, String extensionXml, Boolean skipOutputTypeValidation) {
        this.connectorName = connectorName;
        this.connectorXmlName = XmlUtils.getXmlName(connectorName);
        this.protocols = protocols;
        this.description = description;
        this.mvnGroupId = mvnGroupId;
        this.mvnArtifactId = mvnArtifactId;
        this.mvnVersion = mvnVersion;
        this.basePackage = basePackage;
        this.category = category;
        this.baseUri = baseUri;
        this.operations = operations;
        this.extensionXml = extensionXml;
        this.skipOutputTypeValidation = skipOutputTypeValidation;
        if (paginations != null) {
            paginations.forEach(paging -> this.paginations.put(paging.getName(), (Pagination)paging));
        }
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public List<ConnectorOperation> getOperations() {
        return this.operations;
    }

    public String getMvnGroupId() {
        return this.mvnGroupId;
    }

    public String getMvnArtifactId() {
        return this.mvnArtifactId;
    }

    public String getMvnVersion() {
        return this.mvnVersion;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public ConnectorCategory getCategory() {
        return this.category;
    }

    public BaseUri getBaseUri() {
        return this.baseUri;
    }

    public String getConnectorXmlName() {
        return this.connectorXmlName;
    }

    public String getApiDescription() {
        return this.description;
    }

    public Pagination getPagination(String pagingName) {
        return this.paginations.getOrDefault(pagingName, null);
    }

    public int getPaginationStrategies() {
        return this.paginations.size();
    }

    public boolean supportsHTTP() {
        return this.protocols.contains((Object)Protocol.HTTP);
    }

    public boolean supportsHTTPS() {
        return this.protocols.contains((Object)Protocol.HTTPS);
    }

    public String getExtensionXml() {
        return this.extensionXml;
    }

    public Boolean getSkipOutputTypeValidation() {
        return this.skipOutputTypeValidation;
    }
}

