/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.DuplicatedParameterNameException;
import org.mule.connectivity.restconnect.exception.InvalidSourceException;
import org.mule.connectivity.restconnect.internal.connectormodel.HTTPMethod;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.PartParameter;
import org.mule.connectivity.restconnect.internal.connectormodel.security.ConnectorSecurityScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.type.MultipartTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.webapi.util.OperationNamingUtils;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class ConnectorOperation {
    private String internalName;
    private String displayName;
    private final String description;
    private final String alternativeBaseUri;
    private final String path;
    private final HTTPMethod httpMethod;
    private final String pagination;
    private final List<Parameter> uriParameters;
    private final List<Parameter> queryParameters;
    private final List<Parameter> headers;
    private final List<Parameter> allParameters;
    private final TypeDefinition inputMetadata;
    private final TypeDefinition outputMetadata;
    private final Boolean skipOutputTypeValidation;
    private final Boolean voidOperation;
    private List<ConnectorSecurityScheme> securitySchemes;

    public ConnectorOperation(String displayName, String description, String path, HTTPMethod httpMethod, List<Parameter> uriParameters, List<Parameter> queryParameters, List<Parameter> headers, TypeDefinition inputMetadata, TypeDefinition outputMetadata, List<ConnectorSecurityScheme> securitySchemes, String alternativeBaseUri, String pagination, Boolean skipOutputTypeValidation, Boolean voidOperation) throws InvalidSourceException {
        this.internalName = XmlUtils.getXmlName(OperationNamingUtils.buildCanonicalOperationName(httpMethod, path));
        this.displayName = displayName;
        this.description = description;
        this.path = path;
        this.httpMethod = httpMethod;
        this.uriParameters = uriParameters;
        this.queryParameters = queryParameters;
        this.headers = headers;
        this.inputMetadata = inputMetadata;
        this.outputMetadata = outputMetadata;
        this.securitySchemes = securitySchemes;
        this.allParameters = this.validateParameters();
        this.alternativeBaseUri = alternativeBaseUri;
        this.pagination = pagination;
        this.skipOutputTypeValidation = skipOutputTypeValidation;
        this.voidOperation = voidOperation;
    }

    private List<Parameter> validateParameters() throws InvalidSourceException {
        LinkedList<Parameter> allParams = new LinkedList<Parameter>();
        allParams.addAll(this.getQueryParameters());
        allParams.addAll(this.getUriParameters());
        allParams.addAll(this.getHeaders());
        allParams.addAll(this.getMultipartyBodyPartParameters());
        ArrayList<String> keys = new ArrayList<String>();
        for (Parameter param : allParams) {
            if (keys.stream().anyMatch(str -> str.equals(param.getInternalName()))) {
                throw new InvalidSourceException("Invalid spec: Duplicated parameter names", new DuplicatedParameterNameException(param.getInternalName(), this.getInternalName(), this.getPath()));
            }
            keys.add(param.getInternalName());
        }
        return allParams;
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Parameter> getUriParameters() {
        return this.uriParameters;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    private List<Parameter> getMultipartyBodyPartParameters() {
        LinkedList<Parameter> partParameters = new LinkedList<Parameter>();
        if (this.inputMetadata instanceof MultipartTypeDefinition) {
            for (PartParameter part : ((MultipartTypeDefinition)this.inputMetadata).getParts()) {
                if (part.getPartNameParameter() != null) {
                    partParameters.add(part.getPartNameParameter());
                }
                if (part.getPartFilenameParameter() == null) continue;
                partParameters.add(part.getPartFilenameParameter());
            }
        }
        return partParameters;
    }

    public String getHttpMethod() {
        return this.httpMethod.toString().toLowerCase();
    }

    public String getPath() {
        return this.path;
    }

    public List<Parameter> getAllParameters() {
        return this.allParameters;
    }

    public String getDescription() {
        return this.description;
    }

    public TypeDefinition getInputMetadata() {
        return this.inputMetadata;
    }

    public TypeDefinition getOutputMetadata() {
        return this.outputMetadata;
    }

    public List<ConnectorSecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAlternativeBaseUri() {
        return this.alternativeBaseUri;
    }

    public String getPagination() {
        return this.pagination;
    }

    public boolean hasPagination() {
        return StringUtils.isNotBlank((CharSequence)this.pagination);
    }

    public Boolean getSkipOutputTypeValidation() {
        return this.skipOutputTypeValidation;
    }

    public Boolean getVoidOperation() {
        return this.voidOperation;
    }
}

