/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorParameterBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorTypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.connectormodel.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.ConnectorSecurityScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.NotSupportedScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.UnsecuredScheme;
import org.mule.connectivity.restconnect.internal.descriptor.model.SecuritySchemeDescriptor;
import org.mule.connectivity.restconnect.internal.webapi.model.APISecuritySchemeModel;

public class ConnectorSecuritySchemeBuilder {
    private final ConnectorParameterBuilder parameterBuilder;

    public ConnectorSecuritySchemeBuilder(ConnectorTypeDefinitionBuilder connectorTypeDefinitionBuilder) {
        this.parameterBuilder = new ConnectorParameterBuilder(connectorTypeDefinitionBuilder);
    }

    public List<ConnectorSecurityScheme> buildSecuritySchemes(List<APISecuritySchemeModel> apiSecuritySchemeModels, List<SecuritySchemeDescriptor> securities) throws ModelGenerationException {
        LinkedList<ConnectorSecurityScheme> apiSecuritySchemes = new LinkedList<ConnectorSecurityScheme>();
        if (!apiSecuritySchemeModels.isEmpty()) {
            for (APISecuritySchemeModel securitySchemeModel : apiSecuritySchemeModels) {
                ConnectorSecurityScheme apiSecurityScheme = this.buildSecurityScheme(securitySchemeModel, this.getSecuritySchemeDescriptor(securities, securitySchemeModel));
                if (apiSecurityScheme == null || apiSecurityScheme instanceof NotSupportedScheme) continue;
                apiSecuritySchemes.add(apiSecurityScheme);
            }
        } else {
            apiSecuritySchemes.add(new UnsecuredScheme());
        }
        return apiSecuritySchemes;
    }

    private SecuritySchemeDescriptor getSecuritySchemeDescriptor(List<SecuritySchemeDescriptor> securities, APISecuritySchemeModel securitySchemeModel) {
        return securities.stream().filter(x -> x.getDisplayName().equalsIgnoreCase(securitySchemeModel.getName())).findFirst().orElse(null);
    }

    private ConnectorSecurityScheme buildSecurityScheme(APISecuritySchemeModel securitySchemeModel, SecuritySchemeDescriptor securitySchemeDescriptor) throws ModelGenerationException {
        if (securitySchemeDescriptor != null && securitySchemeDescriptor.isIgnored()) {
            return null;
        }
        Class<? extends ConnectorSecurityScheme> securitySchemeClass = securitySchemeModel.getSecuritySchemeClass();
        LinkedList<String> collisionNames = new LinkedList<String>();
        List<Parameter> customQueryParams = this.parameterBuilder.buildParameterList(securitySchemeModel.getCustomQueryParams(), securitySchemeDescriptor, collisionNames);
        collisionNames.addAll(customQueryParams.stream().map(Parameter::getInternalName).collect(Collectors.toList()));
        List<Parameter> customHeaders = this.parameterBuilder.buildParameterList(securitySchemeModel.getCustomHeaders(), securitySchemeDescriptor, collisionNames);
        ConnectorSecurityScheme.Builder builder = ConnectorSecurityScheme.builder(securitySchemeModel.getName(), customQueryParams, customHeaders);
        if (securitySchemeClass.equals(BasicAuthScheme.class)) {
            return builder.buildBasicAuthScheme();
        }
        if (securitySchemeClass.equals(CustomAuthenticationScheme.class)) {
            return builder.buildCustomAuthenticationScheme();
        }
        if (securitySchemeClass.equals(DigestAuthenticationScheme.class)) {
            return builder.buildDigestAuthenticationSchemeScheme();
        }
        if (securitySchemeClass.equals(OAuth2AuthorizationCodeScheme.class)) {
            return builder.buildOAuth2AuthorizationCodeScheme(securitySchemeModel.getAuthorizationUri(), securitySchemeModel.getAccessTokenUri(), securitySchemeModel.getScopes());
        }
        if (securitySchemeClass.equals(OAuth2ClientCredentialsScheme.class)) {
            return builder.buildOAuth2ClientCredentialsScheme(securitySchemeModel.getAuthorizationUri(), securitySchemeModel.getAccessTokenUri(), securitySchemeModel.getScopes());
        }
        if (securitySchemeClass.equals(PassThroughScheme.class)) {
            return builder.buildPassThroughScheme();
        }
        return builder.buildUnsecuredScheme();
    }
}

