/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.security;

import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.connectormodel.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.UnsecuredScheme;
import org.mule.connectivity.restconnect.internal.util.HashCodeUtil;

public abstract class ConnectorSecurityScheme {
    protected final List<Parameter> headers = new LinkedList<Parameter>();
    protected final List<Parameter> queryParameters = new LinkedList<Parameter>();
    protected final SecuritySchemeType schemeType;
    protected final String displayName;

    public ConnectorSecurityScheme(SecuritySchemeType schemeType, String displayName) {
        this.schemeType = schemeType;
        this.displayName = displayName;
    }

    public SecuritySchemeType getSecuritySchemeType() {
        return this.schemeType;
    }

    public String getDisplayName() {
        if (this.schemeType.equals((Object)SecuritySchemeType.UNSECURED)) {
            return SecuritySchemeType.UNSECURED.name();
        }
        return this.displayName;
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectorSecurityScheme)) {
            return false;
        }
        ConnectorSecurityScheme that = (ConnectorSecurityScheme)o;
        return that.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return HashCodeUtil.generateHashCode(new Object[]{this.schemeType, this.headers, this.queryParameters});
    }

    public static Builder builder(String displayName, List<Parameter> customQueryParams, List<Parameter> customHeaders) {
        return new Builder(displayName, customQueryParams, customHeaders);
    }

    public static class Builder {
        private final List<Parameter> customHeaders;
        private final List<Parameter> customQueryParams;
        private final String displayName;

        public Builder(String displayName, List<Parameter> customQueryParams, List<Parameter> customHeaders) {
            this.customHeaders = customHeaders;
            this.customQueryParams = customQueryParams;
            this.displayName = displayName;
        }

        public BasicAuthScheme buildBasicAuthScheme() {
            return new BasicAuthScheme(this.displayName);
        }

        public CustomAuthenticationScheme buildCustomAuthenticationScheme() {
            return new CustomAuthenticationScheme(this.displayName, this.customQueryParams, this.customHeaders);
        }

        public DigestAuthenticationScheme buildDigestAuthenticationSchemeScheme() {
            return new DigestAuthenticationScheme(this.displayName);
        }

        public OAuth2AuthorizationCodeScheme buildOAuth2AuthorizationCodeScheme(String authorizationUri, String accessTokenUri, List<String> scopes) {
            return new OAuth2AuthorizationCodeScheme(this.displayName, authorizationUri, accessTokenUri, scopes, this.customQueryParams, this.customHeaders);
        }

        public OAuth2ClientCredentialsScheme buildOAuth2ClientCredentialsScheme(String authorizationUri, String accessTokenUri, List<String> scopes) {
            return new OAuth2ClientCredentialsScheme(this.displayName, authorizationUri, accessTokenUri, scopes, this.customQueryParams, this.customHeaders);
        }

        public PassThroughScheme buildPassThroughScheme() {
            return new PassThroughScheme(this.displayName, this.customQueryParams, this.customHeaders);
        }

        public UnsecuredScheme buildUnsecuredScheme() {
            return new UnsecuredScheme();
        }
    }

    public static enum SecuritySchemeType {
        BASIC("Basic Authentication"),
        OAUTH1("OAuth 1.0"),
        OAUTH2("OAuth 2.0"),
        PASS_THROUGH("Pass Through"),
        DIGEST_AUTHENTICATION("Digest Authentication"),
        CUSTOM_AUTHENTICATION("Custom Authentication"),
        UNSECURED("Unsecured"),
        NOT_SUPPORTED("Not Supported");

        private final String type;

        private SecuritySchemeType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

