/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkTypeDefinition;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;

public abstract class SdkAbstractStaticTypeResolver
extends JavaTemplateEntity {
    private static final String GET_SCHEMA_PATH_METHOD_NAME = "getSchemaPath";
    private static final String GET_CATEGORY_NAME_METHOD_NAME = "getCategoryName";
    private static final String GET_QNAME_METHOD_NAME = "getQName";
    protected final boolean requiresTypeResolver;
    private String className;
    private String javaPackage;
    private String schemaPath;
    private String categoryName;
    protected Class<?> superclass;

    public SdkAbstractStaticTypeResolver(Path outputDir, ConnectorModel connectorModel, ConnectorOperation operation, TypeDefinition typeDefinition, SdkTypeDefinition sdkTypeDefinition) {
        super(outputDir, connectorModel);
        this.requiresTypeResolver = this.buildRequiresTypeResolver(typeDefinition, sdkTypeDefinition);
        if (this.requiresTypeResolver) {
            this.className = this.buildClassName(operation);
            this.javaPackage = this.buildPackage(connectorModel);
            this.schemaPath = sdkTypeDefinition.getSchemaPath();
            this.categoryName = this.buildCategoryName(operation);
            this.superclass = this.buildSuperclass(typeDefinition);
        }
    }

    protected abstract Class<?> buildSuperclass(TypeDefinition var1);

    private boolean buildRequiresTypeResolver(TypeDefinition typeDefinition, SdkTypeDefinition sdkTypeDefinition) {
        return typeDefinition.getTypeSchema() != null && StringUtils.isNotBlank((CharSequence)sdkTypeDefinition.getSchemaPath());
    }

    protected abstract String getClassNameSuffix();

    private String buildClassName(ConnectorOperation operation) {
        return JavaUtils.getJavaUpperCamelNameFromXml(operation.getInternalName()) + this.getClassNameSuffix();
    }

    private String buildCategoryName(ConnectorOperation operation) {
        return operation.getInternalName() + this.getCategorySuffix();
    }

    protected String getCategorySuffix() {
        return "-type-resolver";
    }

    private String buildPackage(ConnectorModel connectorModel) {
        return connectorModel.getBasePackage() + ".internal.operation.metadata";
    }

    public String getClassName() {
        return this.className;
    }

    public boolean getRequiresTypeResolver() {
        return this.requiresTypeResolver;
    }

    public String getPackage() {
        return this.javaPackage;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.requiresTypeResolver) {
            this.generateTypeResolverClass();
        }
    }

    private void generateTypeResolverClass() throws TemplatingException {
        TypeSpec.Builder typeResolverClassBuilder = TypeSpec.classBuilder((String)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.superclass);
        this.addGetSchemaPathMethod(typeResolverClassBuilder);
        if (this.requiresCategoryNameMethod()) {
            this.addGetCategoryNameMethod(typeResolverClassBuilder);
        }
        if (this.requiresQNameMethod()) {
            this.addGetQNameMethod(typeResolverClassBuilder);
        }
        this.writeClassToFile(typeResolverClassBuilder.build(), this.javaPackage);
    }

    private void addGetSchemaPathMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.schemaPath}).build();
        MethodSpec createConnectionMethod = MethodSpec.methodBuilder((String)GET_SCHEMA_PATH_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(createConnectionMethod);
    }

    private void addGetCategoryNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.categoryName}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_CATEGORY_NAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    private void addGetQNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.getQName()}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_QNAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    protected boolean requiresCategoryNameMethod() {
        return true;
    }

    protected abstract boolean requiresQNameMethod();

    protected abstract String getQName();
}

