/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConfig;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.connectivity.restconnect.internal.webapi.util.ParserUtils;
import org.mule.connectors.restconnect.commons.api.error.RestConnectError;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.license.RequiresEnterpriseLicense;

public class SdkConnector
extends JavaTemplateEntity {
    private final List<SdkConfig> configs;
    private final Map<TypeSchema, String> typeSchemaPaths = new HashMap<TypeSchema, String>();
    private final Map<List<String>, String> enumValuesName = new HashMap<List<String>, String>();

    public SdkConnector(Path outputDir, ConnectorModel connectorModel) {
        super(outputDir, connectorModel);
        this.configs = Stream.of(new SdkConfig(outputDir, connectorModel, this)).collect(Collectors.toList());
    }

    public String getJavaName() {
        return JavaUtils.getJavaUpperCamelNameFromXml(this.connectorModel.getConnectorXmlName());
    }

    private Category getCategory() {
        return this.connectorModel.getCategory() != null ? Category.valueOf((String)this.connectorModel.getCategory().getCategoryName().toUpperCase()) : null;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateConnectorClass();
        for (SdkConfig config : this.configs) {
            config.applyTemplates();
        }
    }

    private void generateConnectorClass() throws TemplatingException {
        TypeSpec.Builder connectorClassBuilder = TypeSpec.classBuilder((String)JavaUtils.getJavaUpperCamelNameFromXml(this.connectorModel.getConnectorXmlName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.getExtensionAnnotation()).addAnnotation(this.getXmlAnnotation()).addAnnotation(this.getConfigurationsAnnotation()).addAnnotation(this.getErrorTypesAnnotation());
        if (this.getCategory() != null) {
            connectorClassBuilder.addAnnotation(this.getLicenseAnnotation());
        }
        this.writeClassToFile(connectorClassBuilder.build(), this.getPackage());
    }

    private String getPackage() {
        return this.connectorModel.getBasePackage() + ".internal";
    }

    private AnnotationSpec getExtensionAnnotation() {
        String extensionName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, this.connectorModel.getConnectorXmlName());
        extensionName = ParserUtils.splitCaps(extensionName, " ");
        AnnotationSpec.Builder extensionAnnotationBuilder = AnnotationSpec.builder(Extension.class).addMember("name", "$S", new Object[]{extensionName});
        if (this.getCategory() != null) {
            extensionAnnotationBuilder.addMember("category", "$T.$L", new Object[]{Category.class, this.getCategory()});
        }
        return extensionAnnotationBuilder.build();
    }

    private AnnotationSpec getLicenseAnnotation() {
        AnnotationSpec.Builder connectorAnnotationBuilder = AnnotationSpec.builder(RequiresEnterpriseLicense.class).addMember("allowEvaluationLicense", "$L", new Object[]{true});
        return connectorAnnotationBuilder.build();
    }

    private AnnotationSpec getXmlAnnotation() {
        AnnotationSpec.Builder connectorAnnotationBuilder = AnnotationSpec.builder(Xml.class).addMember("prefix", "$S", new Object[]{this.connectorModel.getExtensionXml()});
        return connectorAnnotationBuilder.build();
    }

    private AnnotationSpec getConfigurationsAnnotation() {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.add("{", new Object[0]);
        for (int i = 0; i < this.configs.size(); ++i) {
            SdkConfig config = this.configs.get(i);
            codeBlock.add("$T.class", new Object[]{ClassName.get((String)config.getPackage(), (String)config.getJavaClassName(), (String[])new String[0])});
            if (i >= this.configs.size() - 1) continue;
            codeBlock.add(",", new Object[0]);
        }
        codeBlock.add("}", new Object[0]);
        AnnotationSpec.Builder configurationsAnnotationBuilder = AnnotationSpec.builder(Configurations.class).addMember("value", codeBlock.build());
        return configurationsAnnotationBuilder.build();
    }

    private AnnotationSpec getErrorTypesAnnotation() {
        return AnnotationSpec.builder(ErrorTypes.class).addMember("value", "$T.class", new Object[]{RestConnectError.class}).build();
    }

    public Map<TypeSchema, String> getTypeSchemaPaths() {
        return this.typeSchemaPaths;
    }

    public Map<List<String>, String> getEnumValuesName() {
        return this.enumValuesName;
    }
}

