/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.templating.JavaTemplateEntity;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkInputTypeResolver;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkTypeDefinition;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;

public class SdkContent
extends JavaTemplateEntity {
    private final SdkTypeDefinition sdkTypeDefinition;
    private final SdkInputTypeResolver inputTypeResolver;

    public SdkContent(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) {
        super(outputDir, connectorModel);
        this.sdkTypeDefinition = new SdkTypeDefinition(sdkConnector, operation, true);
        this.inputTypeResolver = new SdkInputTypeResolver(outputDir, connectorModel, operation, operation.getInputMetadata(), this.sdkTypeDefinition);
    }

    private TypeName getTypeName() {
        Type type = this.sdkTypeDefinition.getJavaType();
        return ParameterizedTypeName.get(TypedValue.class, (Type[])new Type[]{type});
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.inputTypeResolver.applyTemplates();
    }

    public ParameterSpec generateContentParameter() {
        ParameterSpec.Builder paramSpecBuilder = ParameterSpec.builder((TypeName)this.getTypeName(), (String)"content", (Modifier[])new Modifier[0]).addAnnotation(this.generateContentAnnotation());
        if (this.inputTypeResolver.getRequiresTypeResolver()) {
            paramSpecBuilder.addAnnotation(this.generateTypeResolverAnnotation());
        }
        return paramSpecBuilder.build();
    }

    private AnnotationSpec generateTypeResolverAnnotation() {
        return AnnotationSpec.builder(TypeResolver.class).addMember("value", "$T.class", new Object[]{ClassName.get((String)this.inputTypeResolver.getPackage(), (String)this.inputTypeResolver.getClassName(), (String[])new String[0])}).build();
    }

    private AnnotationSpec generateContentAnnotation() {
        return AnnotationSpec.builder(Content.class).addMember("primary", "$L", new Object[]{true}).build();
    }
}

