/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.ArrayTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;

public class SdkTypeDefinition {
    private static final String SCHEMAS_FOLDER = "schemas";
    private final TypeDefinition typeDefinition;
    private String schemaPath;
    private String elementName;

    public SdkTypeDefinition(TypeDefinition typeDefinition) {
        this.typeDefinition = typeDefinition;
    }

    public SdkTypeDefinition(SdkConnector sdkConnector, ConnectorOperation operation, boolean input) {
        this.typeDefinition = input ? operation.getInputMetadata() : operation.getOutputMetadata();
        Path resourcesDir = sdkConnector.getResourcesPath();
        if (this.typeRequiresSchemaGeneration()) {
            this.schemaPath = "/schemas/" + FileGenerationUtils.writeSchema(this.typeDefinition.getTypeSchema(), operation, input, resourcesDir.resolve(SCHEMAS_FOLDER), sdkConnector.getTypeSchemaPaths());
            this.elementName = this.buildElementName(this.typeDefinition);
        }
    }

    private String buildElementName(TypeDefinition typeDefinition) {
        if (typeDefinition.getTypeSchema() instanceof XmlTypeSchema) {
            return ((XmlTypeSchema)typeDefinition.getTypeSchema()).getElementName();
        }
        return null;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public String getElementName() {
        return this.elementName;
    }

    public Type getJavaType() {
        if (this.typeDefinition instanceof PrimitiveTypeDefinition) {
            return this.getJavaPrimitiveType((PrimitiveTypeDefinition)this.typeDefinition);
        }
        return InputStream.class;
    }

    private boolean typeRequiresSchemaGeneration() {
        return this.getJavaType().equals(InputStream.class) && !(this.typeDefinition instanceof EmptyTypeDefinition);
    }

    public Type getParameterPrimitiveJavaType() {
        if (this.typeDefinition instanceof ArrayTypeDefinition) {
            throw new IllegalArgumentException("Type is not primitive. Should handle arrays in templating.");
        }
        if (this.typeDefinition instanceof PrimitiveTypeDefinition && !this.getJavaType().equals(InputStream.class)) {
            Type javaType = this.getJavaType();
            if (javaType.equals(Date.class)) {
                return String.class;
            }
            return javaType;
        }
        return String.class;
    }

    public TypeName getParameterTypeName() {
        return this.getParameterTypeName(false);
    }

    private TypeName getParameterTypeName(boolean isInnerType) {
        if (this.typeDefinition instanceof ArrayTypeDefinition) {
            SdkTypeDefinition innerType = new SdkTypeDefinition(((ArrayTypeDefinition)this.typeDefinition).getInnerType());
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{innerType.getParameterTypeName(true)});
        }
        Type parameterPrimitiveJavaType = this.getParameterPrimitiveJavaType();
        if (isInnerType && parameterPrimitiveJavaType.equals(Boolean.TYPE)) {
            return TypeName.get(Boolean.class);
        }
        return TypeName.get((Type)parameterPrimitiveJavaType);
    }

    public boolean isArrayType() {
        return this.typeDefinition instanceof ArrayTypeDefinition;
    }

    public boolean isEnum() {
        return this.typeDefinition.isEnum();
    }

    public List<String> getEnumValues() {
        return this.typeDefinition.getEnumValues();
    }

    private Type getJavaPrimitiveType(PrimitiveTypeDefinition primitiveTypeDefinition) {
        switch (primitiveTypeDefinition.getPrimitiveType()) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case NUMBER: {
                return Double.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case DATE: 
            case DATE_TIME: 
            case DATE_ONLY: 
            case DATE_TIME_ONLY: 
            case TIME_ONLY: {
                return Date.class;
            }
            case FILE: {
                return InputStream.class;
            }
            case STRING: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("PrimitiveTypeDefinition not supported : " + (Object)((Object)primitiveTypeDefinition.getPrimitiveType()));
    }
}

