/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.ModelValidator;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationEngine {
    private static Logger logger = LoggerFactory.getLogger(ValidationEngine.class);
    private static final ModelValidator modelValidator = ModelValidator.defaultModelValidator();
    private ConnectorDescriptor connectorDescriptor;
    private APIModel apiModel;

    public boolean preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        this.connectorDescriptor = connectorDescriptor;
        this.apiModel = apiModel;
        List<ValidationResult> validationResults = modelValidator.preValidate(apiModel, connectorDescriptor);
        this.reportValidationResults(validationResults);
        return validationResults.stream().noneMatch(x -> x.getLevel().equals((Object)ValidationRule.Level.ERROR));
    }

    public boolean postValidate(ConnectorModel connectorModel) {
        List<ValidationResult> validationResults = modelValidator.postValidate(this.apiModel, this.connectorDescriptor, connectorModel);
        this.reportValidationResults(validationResults);
        return validationResults.stream().noneMatch(x -> x.getLevel().equals((Object)ValidationRule.Level.ERROR));
    }

    private void reportValidationResults(List<ValidationResult> validationResults) {
        List<ValidationResult> errorList = validationResults.stream().filter(x -> x.getLevel().equals((Object)ValidationRule.Level.ERROR)).collect(Collectors.toList());
        List<ValidationResult> warnList = validationResults.stream().filter(x -> x.getLevel().equals((Object)ValidationRule.Level.WARN)).collect(Collectors.toList());
        List<ValidationResult> infoList = validationResults.stream().filter(x -> x.getLevel().equals((Object)ValidationRule.Level.INFO)).collect(Collectors.toList());
        errorList.forEach(x -> logger.error(x.toString() + System.lineSeparator()));
        warnList.forEach(x -> logger.warn(x.toString() + System.lineSeparator()));
        infoList.forEach(x -> logger.warn(x.toString() + System.lineSeparator()));
    }
}

