/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.EndPointDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.OperationDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;

public class DescriptorInputMediaTypeMustBePresentInApiRule
extends PreValidationRule {
    public DescriptorInputMediaTypeMustBePresentInApiRule() {
        super("The input media type defined in the descriptor is not present in the API spec", "If the API spec defines a set of input media types for an operation the Descriptor must use one of those to define the operation's default input media type.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> allErrors = new LinkedList<ValidationResult>();
        for (EndPointDescriptor endpointDesc : connectorDescriptor.getEndpoints()) {
            List errors = endpointDesc.getOperations().stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getInputMediaType())).filter(x -> this.apiDefinesMediaTypes(apiModel, endpointDesc.getPath(), (OperationDescriptor)x)).filter(x -> !this.mediaTypePresentInApi(apiModel, endpointDesc.getPath(), (OperationDescriptor)x)).map(x -> this.getValidationErrorForDescriptor(endpointDesc.getPath(), x.getMethod(), x.getInputMediaType())).collect(Collectors.toList());
            allErrors.addAll(errors);
        }
        String globalMediaType = connectorDescriptor.getDefaultInputMediaType();
        if (StringUtils.isNotBlank((CharSequence)globalMediaType)) {
            List globalErrors = apiModel.getOperationsModel().stream().filter(x -> !x.getInputMetadataModel().isEmpty()).filter(x -> x.getInputMetadataModel().stream().anyMatch(y -> y.getMediaType() != null)).filter(x -> !this.descriptorDefinesMediaType(connectorDescriptor, (APIOperationModel)x)).filter(x -> !this.descriptorDefinesOperationMediaType(globalMediaType, (APIOperationModel)x)).map(x -> this.getValidationErrorForDescriptor(x.getPath(), x.getHttpMethod().name(), globalMediaType)).collect(Collectors.toList());
            allErrors.addAll(globalErrors);
        }
        return allErrors;
    }

    protected boolean descriptorDefinesOperationMediaType(String globalMediaType, APIOperationModel apiOperationModel) {
        return apiOperationModel.getInputMetadataModel().stream().anyMatch(y -> y.getMediaType().toString().equalsIgnoreCase(globalMediaType));
    }

    private boolean descriptorDefinesMediaType(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperation) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperation.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperation.getHttpMethod().name())).anyMatch(x -> StringUtils.isNotBlank((CharSequence)x.getInputMediaType()));
    }

    private boolean mediaTypePresentInApi(APIModel apiModel, String path, OperationDescriptor operationDesc) {
        String inputMediaType = operationDesc.getInputMediaType();
        String method = operationDesc.getMethod();
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path) && x.getHttpMethod().name().equalsIgnoreCase(method)).flatMap(x -> x.getInputMetadataModel().stream()).map(APITypeModel::getMediaType).anyMatch(x -> x.toString().equalsIgnoreCase(inputMediaType));
    }

    private boolean apiDefinesMediaTypes(APIModel apiModel, String path, OperationDescriptor operationDesc) {
        String method = operationDesc.getMethod();
        Optional<APIOperationModel> any = apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path) && x.getHttpMethod().name().equalsIgnoreCase(method)).filter(x -> !x.getInputMetadataModel().isEmpty()).findAny();
        return any.isPresent();
    }

    private ValidationResult getValidationErrorForDescriptor(String path, String method, String mediaType) {
        String location = "Operation with PATH: " + path + " and METHOD: " + method + " does not declare '" + mediaType + "' media type";
        return new ValidationResult(this, location);
    }
}

