/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.util.JavaUtils;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class GavGroupIdMustBeValidRule
extends PreValidationRule {
    public GavGroupIdMustBeValidRule() {
        super("Descriptor connectorGav's groupId must ve a valid Maven groupId", "The groupId defined in the connector descriptor for the connectorGav must ve a valid java package name.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String groupId = connectorDescriptor.getConnectorGav().getGroupId();
        String validGroupId = XmlUtils.removeMavenGroupUnwantedCharacters(groupId);
        String validJavaPackageGroupId = JavaUtils.removeJavaPackageUnwantedCharacters(groupId);
        if (!groupId.equalsIgnoreCase(validGroupId) || !groupId.equalsIgnoreCase(validJavaPackageGroupId)) {
            validationResults.add(this.getValidationError());
        }
        return validationResults;
    }

    private ValidationResult getValidationError() {
        return new ValidationResult(this, "'groupId' property declared in the connector descriptor's 'connectorGav' property");
    }
}

