/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;

public class NoDefaultOutputMediaTypeDefinedRule
extends PreValidationRule {
    public NoDefaultOutputMediaTypeDefinedRule() {
        super("No default outputMediaType was set in the Descriptor and multiple are available", "", ValidationRule.Level.INFO);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getOutputMetadataModel().size() > 1).filter(x -> !this.operationHasDefaultOutputType(connectorDescriptor, (APIOperationModel)x)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean operationHasDefaultOutputType(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).anyMatch(x -> StringUtils.isNotBlank((CharSequence)x.getOutputMediaType()));
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + (Object)((Object)apiOperationModel.getHttpMethod());
        return new ValidationResult(this, location);
    }
}

