/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.connectormodel.security.NotSupportedScheme;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;

public class NotSupportedSecuritySchemeRule
extends PreValidationRule {
    public NotSupportedSecuritySchemeRule() {
        super("The API spec defines a security scheme that is not supported", "", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        return apiModel.getOperationsModel().stream().filter(this::anySecuritySchemeNotSupported).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean anySecuritySchemeNotSupported(APIOperationModel apiOperationModel) {
        return !apiOperationModel.getSecuritySchemesModel().isEmpty() && apiOperationModel.getSecuritySchemesModel().stream().anyMatch(x -> x.getSecuritySchemeClass().equals(NotSupportedScheme.class));
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name();
        return new ValidationResult(this, location);
    }
}

