/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.HTTPMethod;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.OperationDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PostValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;

public class OperationMustDeclareResponseBodyRule
extends PostValidationRule {
    public OperationMustDeclareResponseBodyRule() {
        super("Operations must declare a response body", "GET, POST, PATCH and OPTIONS operations defined in the API spec must declare a response body and a type for that body. If they don't the connector descriptor must skip this check, define a response body for the operation, or declare it as void.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        List nullOutputAPIOperations = apiModel.getOperationsModel().stream().filter(x -> this.httpMethodApplies(x.getHttpMethod())).filter(this::hasNoTypeDefinition).collect(Collectors.toList());
        return nullOutputAPIOperations.stream().filter(nullOutputOperation -> !this.validationSkipped(connectorModel, (APIOperationModel)nullOutputOperation)).filter(nullOutputOperation -> !this.isVoidOperation(connectorDescriptor, (APIOperationModel)nullOutputOperation)).filter(nullOutputOperation -> !this.typeDefinedInDescriptor(connectorDescriptor, (APIOperationModel)nullOutputOperation)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean isVoidOperation(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).findFirst().orElse(null);
        return operationDescriptor != null && operationDescriptor.getVoidOperation() != null && operationDescriptor.getVoidOperation() != false;
    }

    private boolean hasNoTypeDefinition(APIOperationModel apiOperationModel) {
        if (apiOperationModel.getOutputMetadataModel().isEmpty()) {
            return true;
        }
        return apiOperationModel.getOutputMetadataModel().stream().anyMatch(OperationMustDeclareResponseBodyRule::hasNoTypeDefinition);
    }

    private static boolean hasNoTypeDefinition(APITypeModel outputType) {
        MediaType outputMediaType = outputType.getMediaType();
        if (outputMediaType != null && outputMediaType.equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
            return false;
        }
        Class<? extends TypeDefinition> outputClass = outputType.getTypeDefinitionClass();
        TypeSchema typeSchema = outputType.getAPITypeSchemaModel().getTypeSchema();
        return typeSchema == null || outputClass == null || outputClass == EmptyTypeDefinition.class;
    }

    private boolean httpMethodApplies(HTTPMethod httpMethod) {
        return httpMethod.equals((Object)HTTPMethod.GET) || httpMethod.equals((Object)HTTPMethod.POST) || httpMethod.equals((Object)HTTPMethod.PATCH) || httpMethod.equals((Object)HTTPMethod.OPTIONS);
    }

    private boolean validationSkipped(ConnectorModel connectorModel, APIOperationModel apiOperationModel) {
        boolean globalSkip = connectorModel.getSkipOutputTypeValidation() != null && connectorModel.getSkipOutputTypeValidation() != false;
        ConnectorOperation connectorOperation = connectorModel.getOperations().stream().filter(x -> x.getHttpMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).findFirst().orElse(null);
        if (connectorOperation == null) {
            return false;
        }
        if (connectorOperation.getSkipOutputTypeValidation() == null) {
            return globalSkip;
        }
        return connectorOperation.getSkipOutputTypeValidation();
    }

    private boolean typeDefinedInDescriptor(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod().name())).findFirst().orElse(null);
        return operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputTypeSchema());
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name();
        return new ValidationResult(this, location);
    }
}

