/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.util.NamingUtil;
import org.mule.connectivity.restconnect.internal.validation.PostValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

public class OperationNameMustBeFriendlyRule
extends PostValidationRule {
    public OperationNameMustBeFriendlyRule() {
        super("Operation display name seems not to be a friendly name", "The displayName should be a human readable name separated with spaces.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        return connectorModel.getOperations().stream().filter(x -> !NamingUtil.isFriendlyName(x.getDisplayName())).map(this::getValidationError).collect(Collectors.toList());
    }

    private ValidationResult getValidationError(ConnectorOperation connectorOperation) {
        String location = "Operation with PATH: " + connectorOperation.getPath() + " and METHOD: " + connectorOperation.getHttpMethod() + " display name is : " + connectorOperation.getDisplayName();
        return new ValidationResult(this, location);
    }
}

