package org.mule.connectivity.exception;

public class InvalidPropertyException extends Raml2ConnectorException {

    private final Object element;
    private String propertyName;

    public InvalidPropertyException(Object element, String propertyName, Throwable cause) {
        super(String.format("Object of type %s does not have a valid property '%s'. Maybe it doesn't have a proper getter?", element.getClass().getSimpleName(), propertyName),
                cause);
        this.propertyName = propertyName;
        this.element = element;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public Object getElement() {
        return element;
    }
}
