package org.mule.connectivity.model;

import static org.apache.commons.lang.WordUtils.capitalizeFully;


public enum ConnectorCategory {

    COMMUNITY,
    SELECT;

    public Boolean requiresLicense() {
        switch (this) {
            case COMMUNITY:
                return false;
            case SELECT:
                return true;
        }

        return null;
    }

    public String getCategoryName() {
        return capitalizeFully(this.name());
    }

    public static ConnectorCategory fromString(String value) {
        for (ConnectorCategory v : values()) {
            if (v.name().equalsIgnoreCase(value))
                return v;
        }
        throw new IllegalArgumentException();
    }

}
