package org.mule.connectivity.model;

public class MavenDependency {

    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private Scope scope;

    public MavenDependency(String groupId, String artifactId, String version, String classifier, Scope scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.scope = scope;
    }

    public MavenDependency(String groupId, String artifactId, String version, Scope scope) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
    }

    public MavenDependency(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return groupId;
    }

    public String getArtifactId() {
        return artifactId;
    }

    public String getVersion() {
        return version;
    }

    public String getClassifier() {
        return classifier;
    }

    public Scope getScope() {
        return scope;
    }

    public static enum Scope {

        COMPILE,
        PROVIDED,
        TEST;

        @Override
        public String toString() {
            return this.name().toLowerCase();
        }

    }

}
