package org.mule.connectivity.model.api;

import org.mule.connectivity.model.api.builder.ConnectorModelBuilder;
import org.mule.connectivity.exception.GenerationException;
import org.mule.connectivity.exception.UnsupportedMediaTypeException;
import org.mule.connectivity.model.operation.ConnectorOperation;
import org.raml.v2.api.model.v10.methods.Method;
import org.mule.connectivity.model.ConnectorCategory;

import static org.mule.connectivity.util.ParserUtils.getXmlName;
import static org.mule.connectivity.util.ParserUtils.removeSpaces;
import static org.mule.connectivity.util.ParserUtils.removeSpacesAndHyphens;


public class ConnectorModel extends RestConnectAPIModel<ConnectorOperation> {

    private final String connectorClassName;
    private final ConnectorCategory category;


    public ConnectorModel(ConnectorModelBuilder builder) throws GenerationException {
        super(builder);

        this.category = builder.getCategory();
        this.connectorClassName = removeSpacesAndHyphens(apiName) + "Connector";
    }

    @Override
    protected ConnectorOperation createOperation(Method method) throws UnsupportedMediaTypeException {
        return new ConnectorOperation(method);
    }

    @Override
    protected String getDefaultGroupId() {
        return "org.mule.modules";
    }

    @Override
    protected String getDefaultArtifactId() {
        return "mule-module-" + removeSpaces(apiName).toLowerCase();
    }

    public String getConnectorName() {
        return getXmlName(this.apiName);
    }

    public String getBasePackage() {
        return this.groupId + "." + removeSpacesAndHyphens(apiName).toLowerCase();
    }

    public ConnectorCategory getCategory() {
        return category;
    }

    public String getClassName() {
        return connectorClassName;
    }

}
