package org.mule.connectivity.model.api.builder;

import org.mule.connectivity.exception.GenerationException;
import org.mule.connectivity.model.MavenDependency;
import org.mule.connectivity.model.api.SmartConnectorModel;

import java.util.ArrayList;
import java.util.List;


public class SmartConnectorModelBuilder extends RestConnectAPIModelBuilder<SmartConnectorModelBuilder, SmartConnectorModel> {

    private String projectDescription;
    private List<MavenDependency> dependencies;

    private SmartConnectorModelBuilder() {
        this.dependencies = new ArrayList<>();
    }

    public static SmartConnectorModelBuilder createSmartConnectorModel() {
        return new SmartConnectorModelBuilder();
    }

    public SmartConnectorModelBuilder withDependency(MavenDependency dependency) {
        this.dependencies.add(dependency);
        return this;
    }

    public SmartConnectorModelBuilder withProjectDescription(String description) {
        this.projectDescription = description;
        return this;
    }

    public List<MavenDependency> getDependencies() {
        return dependencies;
    }

    public String getProjectDescription() {
        return projectDescription;
    }

    @Override
    protected SmartConnectorModel buildModel() throws GenerationException {
        return new SmartConnectorModel(this);
    }

}