package org.mule.connectivity.model.metadata;

import org.mule.connectivity.model.metadata.definition.SimpleTypeDefinition.PrimitiveType;
import org.mule.connectivity.model.metadata.model.PrimitiveMetadataModel;
import org.raml.v2.api.model.v10.datamodel.*;

public class PrimitiveMetadataModelFactory {

    // Private constructor to prevent instantiation.
    private PrimitiveMetadataModelFactory() {

    }

    public static PrimitiveMetadataModel createPrimitiveMetadataModel(String mediaType, TypeDeclaration typeDeclaration) {
        if(typeDeclaration instanceof BooleanTypeDeclaration) {
            return new PrimitiveMetadataModel(mediaType, PrimitiveType.BOOLEAN);
        }

        else if(typeDeclaration instanceof DateTimeOnlyTypeDeclaration) {
            return new PrimitiveMetadataModel(mediaType, PrimitiveType.DATE_TIME_ONLY);
        }

        else if(typeDeclaration instanceof DateTimeTypeDeclaration) {
            return new PrimitiveMetadataModel(mediaType, PrimitiveType.DATE_TIME);
        }

        else if(typeDeclaration instanceof DateTypeDeclaration) {
            return new PrimitiveMetadataModel(mediaType, PrimitiveType.DATE);
        }

        else if(typeDeclaration instanceof FileTypeDeclaration) {
            return new PrimitiveMetadataModel(mediaType, PrimitiveType.FILE);
        }

        else if(typeDeclaration instanceof IntegerTypeDeclaration) {
            return new PrimitiveMetadataModel(mediaType, PrimitiveType.INTEGER);
        }

        else if(typeDeclaration instanceof NumberTypeDeclaration) {
            return new PrimitiveMetadataModel(mediaType, PrimitiveType.NUMBER);
        }

        else if(typeDeclaration instanceof StringTypeDeclaration) {
            return new PrimitiveMetadataModel(mediaType, PrimitiveType.STRING);
        }

        else if(typeDeclaration instanceof TimeOnlyTypeDeclaration) {
            return new PrimitiveMetadataModel(mediaType, PrimitiveType.TIME_ONLY);
        }

        throw new IllegalArgumentException("Type declaration isn't from a primitive type.");
    }

}
