package org.mule.connectivity.model.metadata.definition;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

import static org.apache.commons.io.FileUtils.writeStringToFile;


public abstract class CustomTypeDefinition implements TypeDefinition {

    public abstract String getSchema();

    @Override
    public CustomTypeDefinition getCustomType() {
        return this;
    }

    public abstract boolean definesElement();

    public abstract String getElementName();

    public abstract void generatePojo(String opName, File outputDir, String basePackage) throws IOException;

    public void writeSchema(Path outputDir) throws IOException {
        Path output = outputDir.resolve(getOutputSchemaFilename());
        writeStringToFile(output.toFile(), getSchema());
    }

    public String getOutputSchemaFilename() {
        return getName() + "-schema" + getFileExtension();
    }

    protected abstract String getFileExtension();

    @Override
    public boolean isCustomType() {
        return true;
    }

}
