package org.mule.connectivity.model.metadata.definition;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import org.jsonschema2pojo.*;
import org.jsonschema2pojo.rules.RuleFactory;

import java.io.File;
import java.io.IOException;

import static org.mule.connectivity.util.FileUtils.createTempFile;
import static org.mule.connectivity.util.ParserUtils.getXmlName;


public class JsonTypeDefinition extends CustomTypeDefinition {

    private static final String SCHEMA_EXTENSION = ".json";

    private final String name;
    private final String schema;
    private String generatedFQN;

    public JsonTypeDefinition(String name, String schema) {
        this.name = name;
        this.schema = schema;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public boolean definesElement() {
        return false;
    }

    @Override
    public String getElementName() {
        return null;
    }

    private static GenerationConfig config = new DefaultGenerationConfig() {
        // TODO: Make it configurable
        @Override
        public boolean isGenerateBuilders() { // set config option by overriding method
            return true;
        }

        @Override
        public String getTargetVersion() {
            return "1.7";
        }

        @Override public boolean isIncludeHashcodeAndEquals() {
            return false;
        }
    };

    @Override
    public void generatePojo(String opName, File outputDir, String basePackage) throws IOException {
        SchemaMapper mapper = new SchemaMapper(new RuleFactory(config, new Jackson2Annotator(), new SchemaStore()), new SchemaGenerator());
        JCodeModel codeModel = new JCodeModel();
        JType generatedModel = mapper.generate(codeModel, opName, basePackage + ".pojo." + opName.toLowerCase(), createTempFile(this.schema).toURI().toURL());
        codeModel.build(outputDir);

        this.generatedFQN = generatedModel.fullName();
    }

    @Override
    protected String getFileExtension() {
        return SCHEMA_EXTENSION;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getMule4Type() {
        return getXmlName(name);
    }

    @Override
    public String getJavaType() {
        return generatedFQN;
    }

}
